/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.media;

import com.kitfox.svg.SVGDiagram;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Iterator;
import java.util.concurrent.ExecutorService;
import org.apache.pivot.io.IOTask;
import org.apache.pivot.serialization.SerializationException;
import org.apache.pivot.util.ListenerList;
import org.apache.pivot.util.concurrent.TaskExecutionException;
import org.apache.pivot.util.concurrent.TaskListener;
import org.apache.pivot.wtk.ApplicationContext;
import org.apache.pivot.wtk.Dimensions;
import org.apache.pivot.wtk.Visual;
import org.apache.pivot.wtk.media.BufferedImageSerializer;
import org.apache.pivot.wtk.media.Drawing;
import org.apache.pivot.wtk.media.ImageListener;
import org.apache.pivot.wtk.media.Picture;
import org.apache.pivot.wtk.media.SVGDiagramSerializer;

public abstract class Image
implements Visual {
    protected ImageListenerList imageListeners = new ImageListenerList();

    @Override
    public int getBaseline() {
        return -1;
    }

    public Dimensions getSize() {
        return new Dimensions(this.getWidth(), this.getHeight());
    }

    public void update(int x, int y, int width, int height) {
        this.imageListeners.regionUpdated(this, x, y, width, height);
    }

    public ListenerList<ImageListener> getImageListeners() {
        return this.imageListeners;
    }

    public String toString() {
        return this.getClass().getName() + " [" + this.getWidth() + "," + this.getHeight() + "]";
    }

    public static Image load(URL location) throws TaskExecutionException {
        LoadTask loadTask = new LoadTask(location);
        return loadTask.execute();
    }

    public static LoadTask load(URL location, TaskListener<Image> loadListener) {
        LoadTask loadTask = new LoadTask(location);
        loadTask.execute(loadListener);
        return loadTask;
    }

    public static Image loadFromCache(URL location) {
        if (location == null) {
            throw new IllegalArgumentException("location is null.");
        }
        Image image = (Image)ApplicationContext.getResourceCache().get(location);
        if (image == null) {
            try {
                image = Image.load(location);
                ApplicationContext.getResourceCache().put(location, (Object)image);
            }
            catch (TaskExecutionException exception) {
                throw new IllegalArgumentException(exception);
            }
        }
        return image;
    }

    public static class LoadTask
    extends IOTask<Image> {
        private URL location = null;

        public LoadTask(URL location) {
            this(location, DEFAULT_EXECUTOR_SERVICE);
        }

        public LoadTask(URL location, ExecutorService executorService) {
            super(executorService);
            this.location = location;
        }

        public URL getLocation() {
            return this.location;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Image execute() throws TaskExecutionException {
            Image image = null;
            try {
                InputStream inputStream = null;
                try {
                    inputStream = new IOTask.MonitoredInputStream((IOTask)this, (InputStream)new BufferedInputStream(this.location.openStream()));
                    if (this.location.getFile().endsWith("svg")) {
                        SVGDiagramSerializer serializer = new SVGDiagramSerializer();
                        SVGDiagram diagram = serializer.readObject(inputStream);
                        image = new Drawing(diagram);
                    } else {
                        BufferedImageSerializer serializer = new BufferedImageSerializer();
                        BufferedImage bufferedImage = serializer.readObject(inputStream);
                        image = new Picture(bufferedImage);
                    }
                }
                finally {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
            }
            catch (IOException exception) {
                throw new TaskExecutionException((Throwable)exception);
            }
            catch (SerializationException exception) {
                throw new TaskExecutionException((Throwable)exception);
            }
            return image;
        }
    }

    protected static class ImageListenerList
    extends ListenerList<ImageListener>
    implements ImageListener {
        protected ImageListenerList() {
        }

        @Override
        public void sizeChanged(Image image, int previousWidth, int previousHeight) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                ImageListener listener = (ImageListener)i$.next();
                listener.sizeChanged(image, previousWidth, previousHeight);
            }
        }

        @Override
        public void baselineChanged(Image image, int previousBaseline) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                ImageListener listener = (ImageListener)i$.next();
                listener.baselineChanged(image, previousBaseline);
            }
        }

        @Override
        public void regionUpdated(Image image, int x, int y, int width, int height) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                ImageListener listener = (ImageListener)i$.next();
                listener.regionUpdated(image, x, y, width, height);
            }
        }
    }
}

