/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.effects;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import org.apache.pivot.wtk.Bounds;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.effects.Decorator;

public class BlurDecorator
implements Decorator {
    private int blurMagnitude;
    private Graphics2D graphics = null;
    private BufferedImage bufferedImage = null;
    private Graphics2D bufferedImageGraphics = null;

    public BlurDecorator() {
        this(9);
    }

    public BlurDecorator(int blurMagnitude) {
        this.blurMagnitude = blurMagnitude;
    }

    @Override
    public Graphics2D prepare(Component component, Graphics2D graphicsArgument) {
        this.graphics = graphicsArgument;
        int width = component.getWidth();
        int height = component.getHeight();
        if (this.bufferedImage == null || this.bufferedImage.getWidth() != width || this.bufferedImage.getHeight() != height) {
            this.bufferedImage = new BufferedImage(width, height, 1);
        }
        this.bufferedImageGraphics = this.bufferedImage.createGraphics();
        this.bufferedImageGraphics.setClip(graphicsArgument.getClip());
        return this.bufferedImageGraphics;
    }

    @Override
    public void update() {
        this.bufferedImageGraphics.dispose();
        this.bufferedImageGraphics = null;
        this.bufferedImage.flush();
        float[] kernel = new float[this.blurMagnitude * this.blurMagnitude];
        int n = kernel.length;
        for (int i = 0; i < n; ++i) {
            kernel[i] = 1.0f / (float)n;
        }
        ConvolveOp blur = new ConvolveOp(new Kernel(this.blurMagnitude, this.blurMagnitude, kernel), 1, null);
        this.bufferedImage = blur.filter(this.bufferedImage, null);
        this.graphics.drawImage((Image)this.bufferedImage, 0, 0, null);
        this.bufferedImage = null;
        this.graphics = null;
    }

    @Override
    public Bounds getBounds(Component component) {
        return new Bounds(0, 0, component.getWidth(), component.getHeight());
    }

    @Override
    public AffineTransform getTransform(Component component) {
        return new AffineTransform();
    }
}

