/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk;

import java.util.Iterator;
import java.util.Locale;
import org.apache.pivot.collections.Dictionary;
import org.apache.pivot.json.JSON;
import org.apache.pivot.json.JSONSerializer;
import org.apache.pivot.serialization.SerializationException;
import org.apache.pivot.util.CalendarDate;
import org.apache.pivot.util.Filter;
import org.apache.pivot.util.ListenerList;
import org.apache.pivot.wtk.BindType;
import org.apache.pivot.wtk.CalendarBindingListener;
import org.apache.pivot.wtk.CalendarListener;
import org.apache.pivot.wtk.CalendarSelectionListener;
import org.apache.pivot.wtk.Container;
import org.apache.pivot.wtk.WTKListenerList;

public class Calendar
extends Container {
    private int year;
    private int month;
    private CalendarDate selectedDate = null;
    private Locale locale = Locale.getDefault();
    private Filter<CalendarDate> disabledDateFilter = null;
    private String selectedDateKey = null;
    private BindType selectedDateBindType = BindType.BOTH;
    private SelectedDateBindMapping selectedDateBindMapping = null;
    private CalendarListenerList calendarListeners = new CalendarListenerList();
    private CalendarSelectionListenerList calendarSelectionListeners = new CalendarSelectionListenerList();
    private CalendarBindingListenerList calendarBindingListeners = new CalendarBindingListenerList();
    public static final String LANGUAGE_KEY = "language";
    public static final String COUNTRY_KEY = "country";
    public static final String VARIANT_KEY = "variant";

    public Calendar() {
        this(new CalendarDate());
    }

    private Calendar(CalendarDate calendarDate) {
        this(calendarDate.year, calendarDate.month);
    }

    public Calendar(int year, int month) {
        this.year = year;
        this.month = month;
        this.installSkin(Calendar.class);
    }

    public int getYear() {
        return this.year;
    }

    public void setYear(int year) {
        int previousYear = this.year;
        if (previousYear != year) {
            this.year = year;
            this.calendarListeners.yearChanged(this, previousYear);
        }
    }

    public int getMonth() {
        return this.month;
    }

    public void setMonth(int month) {
        int previousMonth = this.month;
        if (previousMonth != month) {
            this.month = month;
            this.calendarListeners.monthChanged(this, previousMonth);
        }
    }

    public CalendarDate getSelectedDate() {
        return this.selectedDate;
    }

    public void setSelectedDate(CalendarDate selectedDate) {
        CalendarDate previousSelectedDate = this.selectedDate;
        if (previousSelectedDate != selectedDate) {
            this.selectedDate = selectedDate;
            this.calendarSelectionListeners.selectedDateChanged(this, previousSelectedDate);
        }
    }

    public final void setSelectedDate(String selectedDate) {
        if (selectedDate == null) {
            throw new IllegalArgumentException("selectedDate is null.");
        }
        this.setSelectedDate(CalendarDate.decode((String)selectedDate));
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        if (locale == null) {
            throw new IllegalArgumentException("locale is null.");
        }
        Locale previousLocale = this.locale;
        if (previousLocale != locale) {
            this.locale = locale;
            this.calendarListeners.localeChanged(this, previousLocale);
        }
    }

    public void setLocale(Dictionary<String, ?> locale) {
        if (locale == null) {
            throw new IllegalArgumentException("locale is null.");
        }
        String language = (String)locale.get((Object)LANGUAGE_KEY);
        String country = (String)locale.get((Object)COUNTRY_KEY);
        String variant = (String)locale.get((Object)VARIANT_KEY);
        if (variant != null) {
            this.setLocale(new Locale(language, country, variant));
        } else if (country != null) {
            this.setLocale(new Locale(language, country));
        } else {
            this.setLocale(new Locale(language));
        }
    }

    public void setLocale(String locale) {
        if (locale == null) {
            throw new IllegalArgumentException("locale is null.");
        }
        try {
            this.setLocale((Dictionary<String, ?>)JSONSerializer.parseMap((String)locale));
        }
        catch (SerializationException exception) {
            throw new IllegalArgumentException(exception);
        }
    }

    public Filter<CalendarDate> getDisabledDateFilter() {
        return this.disabledDateFilter;
    }

    public void setDisabledDateFilter(Filter<CalendarDate> disabledDateFilter) {
        Filter<CalendarDate> previousDisabledDateFilter = this.disabledDateFilter;
        if (previousDisabledDateFilter != disabledDateFilter) {
            this.disabledDateFilter = disabledDateFilter;
            this.calendarListeners.disabledDateFilterChanged(this, previousDisabledDateFilter);
        }
    }

    public String getSelectedDateKey() {
        return this.selectedDateKey;
    }

    public void setSelectedDateKey(String selectedDateKey) {
        String previousSelectedDateKey = this.selectedDateKey;
        if (selectedDateKey != previousSelectedDateKey) {
            this.selectedDateKey = selectedDateKey;
            this.calendarBindingListeners.selectedDateKeyChanged(this, previousSelectedDateKey);
        }
    }

    public BindType getSelectedDateBindType() {
        return this.selectedDateBindType;
    }

    public void setSelectedDateBindType(BindType selectedDateBindType) {
        if (selectedDateBindType == null) {
            throw new IllegalArgumentException();
        }
        BindType previousSelectedDateBindType = this.selectedDateBindType;
        if (previousSelectedDateBindType != selectedDateBindType) {
            this.selectedDateBindType = selectedDateBindType;
            this.calendarBindingListeners.selectedDateBindTypeChanged(this, previousSelectedDateBindType);
        }
    }

    public SelectedDateBindMapping getSelectedDateBindMapping() {
        return this.selectedDateBindMapping;
    }

    public void setSelectedDateBindMapping(SelectedDateBindMapping selectedDateBindMapping) {
        SelectedDateBindMapping previousSelectedDateBindMapping = this.selectedDateBindMapping;
        if (previousSelectedDateBindMapping != selectedDateBindMapping) {
            this.selectedDateBindMapping = selectedDateBindMapping;
            this.calendarBindingListeners.selectedDateBindMappingChanged(this, previousSelectedDateBindMapping);
        }
    }

    @Override
    public void load(Object context) {
        if (this.selectedDateKey != null && JSON.containsKey((Object)context, (String)this.selectedDateKey) && this.selectedDateBindType != BindType.STORE) {
            Object value = JSON.get((Object)context, (String)this.selectedDateKey);
            CalendarDate selectedDateLocal = null;
            if (value instanceof CalendarDate) {
                selectedDateLocal = (CalendarDate)value;
            } else if (this.selectedDateBindMapping == null) {
                if (value != null) {
                    selectedDateLocal = CalendarDate.decode((String)value.toString());
                }
            } else {
                selectedDateLocal = this.selectedDateBindMapping.toDate(value);
            }
            this.setSelectedDate(selectedDateLocal);
        }
    }

    @Override
    public void store(Object context) {
        if (this.selectedDateKey != null && this.selectedDateBindType != BindType.LOAD) {
            JSON.put((Object)context, (String)this.selectedDateKey, (Object)(this.selectedDateBindMapping == null ? this.selectedDate : this.selectedDateBindMapping.valueOf(this.selectedDate)));
        }
    }

    @Override
    public void clear() {
        if (this.selectedDateKey != null) {
            this.setSelectedDate((CalendarDate)null);
        }
    }

    public ListenerList<CalendarListener> getCalendarListeners() {
        return this.calendarListeners;
    }

    public ListenerList<CalendarSelectionListener> getCalendarSelectionListeners() {
        return this.calendarSelectionListeners;
    }

    public ListenerList<CalendarBindingListener> getCalendarBindingListeners() {
        return this.calendarBindingListeners;
    }

    private static class CalendarBindingListenerList
    extends WTKListenerList<CalendarBindingListener>
    implements CalendarBindingListener {
        private CalendarBindingListenerList() {
        }

        @Override
        public void selectedDateKeyChanged(Calendar calendar, String previousSelectedDateKey) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                CalendarBindingListener listener = (CalendarBindingListener)i$.next();
                listener.selectedDateKeyChanged(calendar, previousSelectedDateKey);
            }
        }

        @Override
        public void selectedDateBindTypeChanged(Calendar calendar, BindType previousSelectedDateBindType) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                CalendarBindingListener listener = (CalendarBindingListener)i$.next();
                listener.selectedDateBindTypeChanged(calendar, previousSelectedDateBindType);
            }
        }

        @Override
        public void selectedDateBindMappingChanged(Calendar calendar, SelectedDateBindMapping previousSelectedDateBindMapping) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                CalendarBindingListener listener = (CalendarBindingListener)i$.next();
                listener.selectedDateBindMappingChanged(calendar, previousSelectedDateBindMapping);
            }
        }
    }

    private static class CalendarSelectionListenerList
    extends WTKListenerList<CalendarSelectionListener>
    implements CalendarSelectionListener {
        private CalendarSelectionListenerList() {
        }

        @Override
        public void selectedDateChanged(Calendar calendar, CalendarDate previousSelectedDate) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                CalendarSelectionListener listener = (CalendarSelectionListener)i$.next();
                listener.selectedDateChanged(calendar, previousSelectedDate);
            }
        }
    }

    private static class CalendarListenerList
    extends WTKListenerList<CalendarListener>
    implements CalendarListener {
        private CalendarListenerList() {
        }

        @Override
        public void yearChanged(Calendar calendar, int previousYear) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                CalendarListener listener = (CalendarListener)i$.next();
                listener.yearChanged(calendar, previousYear);
            }
        }

        @Override
        public void monthChanged(Calendar calendar, int previousMonth) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                CalendarListener listener = (CalendarListener)i$.next();
                listener.monthChanged(calendar, previousMonth);
            }
        }

        @Override
        public void localeChanged(Calendar calendar, Locale previousLocale) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                CalendarListener listener = (CalendarListener)i$.next();
                listener.localeChanged(calendar, previousLocale);
            }
        }

        @Override
        public void disabledDateFilterChanged(Calendar calendar, Filter<CalendarDate> previousDisabledDateFilter) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                CalendarListener listener = (CalendarListener)i$.next();
                listener.disabledDateFilterChanged(calendar, previousDisabledDateFilter);
            }
        }
    }

    public static interface SelectedDateBindMapping {
        public CalendarDate toDate(Object var1);

        public Object valueOf(CalendarDate var1);
    }
}

