/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk;

import java.util.Iterator;
import org.apache.pivot.collections.Dictionary;
import org.apache.pivot.collections.HashMap;
import org.apache.pivot.util.ImmutableIterator;
import org.apache.pivot.util.ListenerList;
import org.apache.pivot.wtk.ActionClassListener;
import org.apache.pivot.wtk.ActionListener;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.WTKListenerList;

public abstract class Action {
    private boolean enabled = true;
    private ActionListenerList actionListeners = new ActionListenerList();
    private static HashMap<String, Action> namedActions = new HashMap();
    private static NamedActionDictionary namedActionDictionary = new NamedActionDictionary();
    private static ActionClassListenerList actionClassListeners = new ActionClassListenerList();

    public Action() {
        this(true);
    }

    public Action(boolean enabled) {
        this.setEnabled(enabled);
    }

    public String getDescription() {
        return null;
    }

    public abstract void perform(Component var1);

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        if (this.enabled != enabled) {
            this.enabled = enabled;
            this.actionListeners.enabledChanged(this);
        }
    }

    public static NamedActionDictionary getNamedActions() {
        return namedActionDictionary;
    }

    public ListenerList<ActionListener> getActionListeners() {
        return this.actionListeners;
    }

    public static ListenerList<ActionClassListener> getActionClassListeners() {
        return actionClassListeners;
    }

    private static class ActionClassListenerList
    extends WTKListenerList<ActionClassListener>
    implements ActionClassListener {
        private ActionClassListenerList() {
        }

        @Override
        public void actionAdded(String id) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                ActionClassListener listener = (ActionClassListener)i$.next();
                listener.actionAdded(id);
            }
        }

        @Override
        public void actionUpdated(String id, Action previousAction) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                ActionClassListener listener = (ActionClassListener)i$.next();
                listener.actionUpdated(id, previousAction);
            }
        }

        @Override
        public void actionRemoved(String id, Action action) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                ActionClassListener listener = (ActionClassListener)i$.next();
                listener.actionRemoved(id, action);
            }
        }
    }

    private static class ActionListenerList
    extends WTKListenerList<ActionListener>
    implements ActionListener {
        private ActionListenerList() {
        }

        @Override
        public void enabledChanged(Action action) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                ActionListener listener = (ActionListener)i$.next();
                listener.enabledChanged(action);
            }
        }
    }

    public static final class NamedActionDictionary
    implements Dictionary<String, Action>,
    Iterable<String> {
        private NamedActionDictionary() {
        }

        public Action get(String id) {
            return (Action)namedActions.get((Object)id);
        }

        public Action put(String id, Action action) {
            if (action == null) {
                throw new IllegalArgumentException("action is null.");
            }
            boolean update = this.containsKey(id);
            Action previousAction = (Action)namedActions.put((Object)id, (Object)action);
            if (update) {
                actionClassListeners.actionUpdated(id, previousAction);
            } else {
                actionClassListeners.actionAdded(id);
            }
            return previousAction;
        }

        public Action remove(String id) {
            Action action = null;
            if (this.containsKey(id)) {
                action = (Action)namedActions.remove((Object)id);
                actionClassListeners.actionRemoved(id, action);
            }
            return action;
        }

        public boolean containsKey(String id) {
            return namedActions.containsKey((Object)id);
        }

        @Override
        public Iterator<String> iterator() {
            return new ImmutableIterator(namedActions.iterator());
        }
    }
}

