/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.preflight.metadata;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentInformation;
import org.apache.pdfbox.preflight.ValidationResult;
import org.apache.pdfbox.preflight.exception.ValidationException;
import org.apache.xmpbox.DateConverter;
import org.apache.xmpbox.XMPMetadata;
import org.apache.xmpbox.schema.AdobePDFSchema;
import org.apache.xmpbox.schema.DublinCoreSchema;
import org.apache.xmpbox.schema.XMPBasicSchema;
import org.apache.xmpbox.type.AbstractField;
import org.apache.xmpbox.type.TextType;

public class SynchronizedMetaDataValidation {
    protected void analyzeTitleProperty(PDDocumentInformation dico, DublinCoreSchema dc, List<ValidationResult.ValidationError> ve) {
        String title = dico.getTitle();
        if (title != null) {
            title = this.removeTrailingNul(title);
            if (dc != null) {
                if (dc.getTitle() != null) {
                    if (dc.getTitle("x-default") != null) {
                        if (!dc.getTitle("x-default").equals(title)) {
                            ve.add(this.unsynchronizedMetaDataError("Title"));
                        }
                    } else {
                        Iterator it = dc.getTitleProperty().getContainer().getAllProperties().iterator();
                        if (it.hasNext()) {
                            AbstractField tmp = (AbstractField)it.next();
                            if (tmp instanceof TextType) {
                                if (!((TextType)tmp).getStringValue().equals(title)) {
                                    ve.add(this.unsynchronizedMetaDataError("Title"));
                                }
                            } else {
                                ve.add(this.absentXMPPropertyError("Title", "Property is badly defined"));
                            }
                        } else {
                            ve.add(this.absentXMPPropertyError("Title", "Property is not defined"));
                        }
                    }
                } else {
                    ve.add(this.absentXMPPropertyError("Title", "Property is not defined"));
                }
            } else {
                ve.add(this.absentSchemaMetaDataError("Title", "Dublin Core"));
            }
        }
    }

    protected void analyzeAuthorProperty(PDDocumentInformation dico, DublinCoreSchema dc, List<ValidationResult.ValidationError> ve) {
        String author = dico.getAuthor();
        if (author != null) {
            author = this.removeTrailingNul(author);
            if (dc != null) {
                if (dc.getCreatorsProperty() != null) {
                    if (dc.getCreators().size() != 1) {
                        ve.add(this.absentXMPPropertyError("Author", "In XMP metadata, Author(s) must be represented by a single entry in a text array (dc:creator) "));
                    } else if (dc.getCreators().get(0) == null) {
                        ve.add(this.absentXMPPropertyError("Author", "Property is defined as null"));
                    } else if (!((String)dc.getCreators().get(0)).equals(author)) {
                        ve.add(this.unsynchronizedMetaDataError("Author"));
                    }
                } else {
                    ve.add(this.absentXMPPropertyError("Author", "Property is not defined in XMP Metadata"));
                }
            } else {
                ve.add(this.absentSchemaMetaDataError("Author", "Dublin Core"));
            }
        }
    }

    protected void analyzeSubjectProperty(PDDocumentInformation dico, DublinCoreSchema dc, List<ValidationResult.ValidationError> ve) {
        String subject = dico.getSubject();
        if (subject != null) {
            subject = this.removeTrailingNul(subject);
            if (dc != null) {
                if (dc.getDescriptionProperty() != null) {
                    if (dc.getDescription("x-default") == null) {
                        ve.add(this.absentXMPPropertyError("Subject", "Subject not found in XMP (dc:description[\"x-default\"] not found)"));
                    } else if (!dc.getDescription("x-default").equals(subject)) {
                        ve.add(this.unsynchronizedMetaDataError("Subject"));
                    }
                } else {
                    ve.add(this.absentXMPPropertyError("Subject", "Property is defined as null"));
                }
            } else {
                ve.add(this.absentSchemaMetaDataError("Subject", "Dublin Core"));
            }
        }
    }

    protected void analyzeKeywordsProperty(PDDocumentInformation dico, AdobePDFSchema pdf, List<ValidationResult.ValidationError> ve) {
        String keyword = dico.getKeywords();
        if (keyword != null) {
            keyword = this.removeTrailingNul(keyword);
            if (pdf != null) {
                if (pdf.getKeywordsProperty() == null) {
                    ve.add(this.absentXMPPropertyError("Keywords", "Property is not defined"));
                } else if (!pdf.getKeywords().equals(keyword)) {
                    ve.add(this.unsynchronizedMetaDataError("Keywords"));
                }
            } else {
                ve.add(this.absentSchemaMetaDataError("Keywords", "PDF"));
            }
        }
    }

    protected void analyzeProducerProperty(PDDocumentInformation dico, AdobePDFSchema pdf, List<ValidationResult.ValidationError> ve) {
        String producer = dico.getProducer();
        if (producer != null) {
            producer = this.removeTrailingNul(producer);
            if (pdf != null) {
                if (pdf.getProducerProperty() == null) {
                    ve.add(this.absentXMPPropertyError("Producer", "Property is not defined"));
                } else if (!pdf.getProducer().equals(producer)) {
                    ve.add(this.unsynchronizedMetaDataError("Producer"));
                }
            } else {
                ve.add(this.absentSchemaMetaDataError("Producer", "PDF"));
            }
        }
    }

    protected void analyzeCreatorToolProperty(PDDocumentInformation dico, XMPBasicSchema xmp, List<ValidationResult.ValidationError> ve) {
        String creatorTool = dico.getCreator();
        if (creatorTool != null) {
            creatorTool = this.removeTrailingNul(creatorTool);
            if (xmp != null) {
                if (xmp.getCreatorToolProperty() == null) {
                    ve.add(this.absentXMPPropertyError("CreatorTool", "Property is not defined"));
                } else if (!xmp.getCreatorTool().equals(creatorTool)) {
                    ve.add(this.unsynchronizedMetaDataError("CreatorTool"));
                }
            } else {
                ve.add(this.absentSchemaMetaDataError("CreatorTool", "PDF"));
            }
        }
    }

    protected void analyzeCreationDateProperty(PDDocumentInformation dico, XMPBasicSchema xmp, List<ValidationResult.ValidationError> ve) throws ValidationException {
        Calendar creationDate = dico.getCreationDate();
        COSBase item = dico.getCOSObject().getItem(COSName.CREATION_DATE);
        if (creationDate != null && this.isValidPDFDateFormat(item)) {
            if (xmp != null) {
                Calendar xmpCreationDate = xmp.getCreateDate();
                if (xmpCreationDate == null) {
                    ve.add(this.absentXMPPropertyError("CreationDate", "Property is not defined"));
                } else if (!DateConverter.toISO8601((Calendar)xmpCreationDate).equals(DateConverter.toISO8601((Calendar)creationDate))) {
                    ve.add(this.unsynchronizedMetaDataError("CreationDate"));
                } else if (this.hasTimeZone(xmp.getCreateDateProperty().getRawValue()) != this.hasTimeZone(dico.getPropertyStringValue("CreationDate"))) {
                    ve.add(this.unsynchronizedMetaDataError("CreationDate"));
                }
            } else {
                ve.add(this.absentSchemaMetaDataError("CreationDate", "Basic XMP"));
            }
        }
    }

    protected void analyzeModifyDateProperty(PDDocumentInformation dico, XMPBasicSchema xmp, List<ValidationResult.ValidationError> ve) throws ValidationException {
        Calendar modifyDate = dico.getModificationDate();
        COSBase item = dico.getCOSObject().getItem(COSName.MOD_DATE);
        if (modifyDate != null && this.isValidPDFDateFormat(item)) {
            if (xmp != null) {
                Calendar xmpModifyDate = xmp.getModifyDate();
                if (xmpModifyDate == null) {
                    ve.add(this.absentXMPPropertyError("ModifyDate", "Property is not defined"));
                } else if (!DateConverter.toISO8601((Calendar)xmpModifyDate).equals(DateConverter.toISO8601((Calendar)modifyDate))) {
                    ve.add(this.unsynchronizedMetaDataError("ModificationDate"));
                } else if (this.hasTimeZone(xmp.getModifyDateProperty().getRawValue()) != this.hasTimeZone(dico.getPropertyStringValue("ModDate"))) {
                    ve.add(this.unsynchronizedMetaDataError("ModificationDate"));
                }
            } else {
                ve.add(this.absentSchemaMetaDataError("ModifyDate", "Basic XMP"));
            }
        }
    }

    public List<ValidationResult.ValidationError> validateMetadataSynchronization(PDDocument document, XMPMetadata metadata) throws ValidationException {
        ArrayList<ValidationResult.ValidationError> ve = new ArrayList<ValidationResult.ValidationError>();
        if (document == null) {
            throw new ValidationException("Document provided is null");
        }
        PDDocumentInformation dico = document.getDocumentInformation();
        if (metadata == null) {
            throw new ValidationException("Metadata provided are null");
        }
        DublinCoreSchema dc = metadata.getDublinCoreSchema();
        this.analyzeTitleProperty(dico, dc, ve);
        this.analyzeAuthorProperty(dico, dc, ve);
        this.analyzeSubjectProperty(dico, dc, ve);
        AdobePDFSchema pdf = metadata.getAdobePDFSchema();
        this.analyzeKeywordsProperty(dico, pdf, ve);
        this.analyzeProducerProperty(dico, pdf, ve);
        XMPBasicSchema xmp = metadata.getXMPBasicSchema();
        this.analyzeCreatorToolProperty(dico, xmp, ve);
        this.analyzeCreationDateProperty(dico, xmp, ve);
        this.analyzeModifyDateProperty(dico, xmp, ve);
        return ve;
    }

    protected ValidationResult.ValidationError unexpectedPrefixFoundError(String prefFound, String prefExpected, String schema) {
        StringBuilder sb = new StringBuilder(80);
        sb.append(schema).append(" found but prefix used is '").append(prefFound).append("', prefix '").append(prefExpected).append("' is expected.");
        return new ValidationResult.ValidationError("7.4.2", sb.toString());
    }

    protected ValidationException schemaAccessException(String target, Throwable cause) {
        StringBuilder sb = new StringBuilder(80);
        sb.append("Cannot access to the ").append(target).append(" schema");
        return new ValidationException(sb.toString(), cause);
    }

    protected ValidationResult.ValidationError unsynchronizedMetaDataError(String target) {
        StringBuilder sb = new StringBuilder(80);
        sb.append(target).append(" present in the document catalog dictionary doesn't match with XMP information");
        return new ValidationResult.ValidationError("7.2", sb.toString());
    }

    protected ValidationResult.ValidationError absentSchemaMetaDataError(String target, String schema) {
        StringBuilder sb = new StringBuilder(80);
        sb.append(target).append(" present in the document catalog dictionary can't be found in XMP information (").append(schema).append(" schema not declared)");
        return new ValidationResult.ValidationError("7.2", sb.toString());
    }

    protected ValidationResult.ValidationError absentXMPPropertyError(String target, String details) {
        StringBuilder sb = new StringBuilder(80);
        sb.append(target).append(" present in the document catalog dictionary can't be found in XMP information (").append(details).append(")");
        return new ValidationResult.ValidationError("7.2", sb.toString());
    }

    private String removeTrailingNul(String string) {
        int length;
        for (length = string.length(); length > 0 && string.charAt(length - 1) == '\u0000'; --length) {
        }
        return string.substring(0, length);
    }

    private boolean hasTimeZone(Object date) {
        String datePattern = "^D:.*[Z]$|^D:.*[+-].*|^\\d{4}.*T.*Z(\\d{2}:\\d{2}){0,1}$|^\\d{4}.*T.*[+-]\\d{2}.*$";
        if (date instanceof Calendar) {
            return true;
        }
        if (date instanceof String) {
            return Pattern.matches("^D:.*[Z]$|^D:.*[+-].*|^\\d{4}.*T.*Z(\\d{2}:\\d{2}){0,1}$|^\\d{4}.*T.*[+-]\\d{2}.*$", (String)date);
        }
        return false;
    }

    private boolean isValidPDFDateFormat(COSBase item) {
        String date;
        return item instanceof COSString && (date = ((COSString)item).getString()).matches("D:\\d{4}(\\d{2}(\\d{2}(\\d{2}(\\d{2}(\\d{2}([\\+\\-Z](\\d{2}'\\d{2}')?)?)?)?)?)?)?");
    }
}

