/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.preflight.font.descriptor;

import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDocument;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.pdmodel.common.PDStream;
import org.apache.pdfbox.pdmodel.font.PDFontDescriptor;
import org.apache.pdfbox.pdmodel.font.PDFontLike;
import org.apache.pdfbox.preflight.PreflightContext;
import org.apache.pdfbox.preflight.ValidationResult;
import org.apache.pdfbox.preflight.font.container.CIDType2Container;
import org.apache.pdfbox.preflight.font.descriptor.FontDescriptorHelper;
import org.apache.pdfbox.preflight.utils.COSUtils;

public class CIDType2DescriptorHelper
extends FontDescriptorHelper<CIDType2Container> {
    public CIDType2DescriptorHelper(PreflightContext context, PDFontLike font, CIDType2Container fontContainer) {
        super(context, font, fontContainer);
    }

    protected void checkCIDSet(PDFontDescriptor pfDescriptor) {
        if (CIDType2DescriptorHelper.isSubSet(pfDescriptor.getFontName())) {
            COSDocument cosDocument = this.context.getDocument().getDocument();
            COSBase cidset = pfDescriptor.getCOSObject().getItem(COSName.getPDFName((String)"CIDSet"));
            if (cidset == null || !COSUtils.isStream(cidset, cosDocument)) {
                ((CIDType2Container)this.fContainer).push(new ValidationResult.ValidationError("3.1.11", pfDescriptor.getFontName() + ": The CIDSet entry is missing for the Composite Subset"));
            }
        }
    }

    @Override
    public PDStream extractFontFile(PDFontDescriptor fontDescriptor) {
        COSStream stream;
        PDStream ff2 = fontDescriptor.getFontFile2();
        if (ff2 != null && (stream = ff2.getStream()) == null) {
            ((CIDType2Container)this.fContainer).push(new ValidationResult.ValidationError("3.1.3", fontDescriptor.getFontName() + ": The FontFile is missing"));
            ((CIDType2Container)this.fContainer).notEmbedded();
        }
        this.checkCIDSet(fontDescriptor);
        return ff2;
    }

    @Override
    protected void processFontFile(PDFontDescriptor fontDescriptor, PDStream fontFile) {
        if (this.font.isDamaged()) {
            ((CIDType2Container)this.fContainer).push(new ValidationResult.ValidationError("3.2.3", this.font.getName() + ": The FontFile can't be read"));
        }
    }
}

