/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.preflight;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.activation.DataSource;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.pdfparser.XrefTrailerResolver;
import org.apache.pdfbox.preflight.PreflightConfiguration;
import org.apache.pdfbox.preflight.PreflightDocument;
import org.apache.pdfbox.preflight.PreflightPath;
import org.apache.pdfbox.preflight.ValidationResult;
import org.apache.pdfbox.preflight.font.container.FontContainer;
import org.apache.pdfbox.preflight.graphic.ICCProfileWrapper;
import org.apache.pdfbox.preflight.utils.COSUtils;
import org.apache.xmpbox.XMPMetadata;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PreflightContext {
    protected Map<COSBase, FontContainer> fontContainers = new HashMap<COSBase, FontContainer>();
    protected PreflightDocument document = null;
    protected DataSource source = null;
    private XrefTrailerResolver xrefTableResolver;
    protected ICCProfileWrapper iccProfileWrapper = null;
    protected boolean iccProfileAlreadySearched = false;
    protected XMPMetadata metadata = null;
    protected PreflightConfiguration config = null;
    protected PreflightPath validationPath = new PreflightPath();

    public PreflightContext(DataSource source) {
        this.source = source;
    }

    public PreflightContext(DataSource source, PreflightConfiguration configuration) {
        this.source = source;
    }

    public XMPMetadata getMetadata() {
        return this.metadata;
    }

    public void setMetadata(XMPMetadata metadata) {
        this.metadata = metadata;
    }

    public PreflightDocument getDocument() {
        return this.document;
    }

    public XrefTrailerResolver getXrefTableResolver() {
        return this.xrefTableResolver;
    }

    public void setXrefTableResolver(XrefTrailerResolver xrefTableResolver) {
        this.xrefTableResolver = xrefTableResolver;
    }

    public void setDocument(PreflightDocument document) {
        this.document = document;
    }

    public DataSource getSource() {
        return this.source;
    }

    public boolean isComplete() {
        return this.document != null && this.source != null;
    }

    public void addFontContainer(COSBase cBase, FontContainer fc) {
        this.fontContainers.put(cBase, fc);
    }

    public FontContainer getFontContainer(COSBase cBase) {
        return this.fontContainers.get(cBase);
    }

    public ICCProfileWrapper getIccProfileWrapper() {
        return this.iccProfileWrapper;
    }

    public void setIccProfileWrapper(ICCProfileWrapper iccProfileWrapper) {
        this.iccProfileWrapper = iccProfileWrapper;
    }

    public PreflightConfiguration getConfig() {
        return this.config;
    }

    public void setConfig(PreflightConfiguration config) {
        this.config = config;
    }

    public void close() {
        COSUtils.closeDocumentQuietly(this.document);
    }

    public void addValidationError(ValidationResult.ValidationError error) {
        PreflightDocument document = this.document;
        document.addValidationError(error);
    }

    public void addValidationErrors(List<ValidationResult.ValidationError> errors) {
        PreflightDocument document = this.document;
        for (ValidationResult.ValidationError error : errors) {
            document.addValidationError(error);
        }
    }

    public PreflightPath getValidationPath() {
        return this.validationPath;
    }

    public void setValidationPath(PreflightPath validationPath) {
        this.validationPath = validationPath;
    }

    public boolean isIccProfileAlreadySearched() {
        return this.iccProfileAlreadySearched;
    }

    public void setIccProfileAlreadySearched(boolean iccProfileAlreadySearched) {
        this.iccProfileAlreadySearched = iccProfileAlreadySearched;
    }
}

