/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.preflight.utils;

import org.apache.pdfbox.preflight.PreflightContext;
import org.apache.pdfbox.preflight.PreflightDocument;
import org.apache.pdfbox.preflight.ValidationResult;

public class FilterHelper {
    public static void isAuthorizedFilter(PreflightContext context, String filter) {
        PreflightDocument preflightDocument = context.getDocument();
        switch (preflightDocument.getSpecification()) {
            case PDF_A1A: {
                FilterHelper.isAuthorizedFilterInPDFA(context, filter);
                break;
            }
            default: {
                FilterHelper.isAuthorizedFilterInPDFA(context, filter);
            }
        }
    }

    public static void isAuthorizedFilterInPDFA(PreflightContext context, String filter) {
        if (filter != null) {
            boolean definedFilter;
            if ("LZWDecode".equals(filter) || "LZW".equals(filter)) {
                context.addValidationError(new ValidationResult.ValidationError("1.2.7", "LZWDecode is forbidden"));
            }
            definedFilter = (definedFilter = "FlateDecode".equals(filter)) || "ASCIIHexDecode".equals(filter);
            definedFilter = definedFilter || "ASCII85Decode".equals(filter);
            definedFilter = definedFilter || "CCITTFaxDecode".equals(filter);
            definedFilter = definedFilter || "DCTDecode".equals(filter);
            definedFilter = definedFilter || "JBIG2Decode".equals(filter);
            definedFilter = definedFilter || "RunLengthDecode".equals(filter);
            definedFilter = definedFilter || "Fl".equals(filter);
            definedFilter = definedFilter || "AHx".equals(filter);
            definedFilter = definedFilter || "A85".equals(filter);
            definedFilter = definedFilter || "CCF".equals(filter);
            definedFilter = definedFilter || "DCT".equals(filter);
            boolean bl = definedFilter = definedFilter || "RL".equals(filter);
            if (!definedFilter) {
                context.addValidationError(new ValidationResult.ValidationError("1.2.12", "This filter isn't defined in the PDF Reference Third Edition : " + filter));
            }
        }
    }
}

