/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.examples.signature.validation;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.security.GeneralSecurityException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.examples.signature.SigUtils;
import org.apache.pdfbox.examples.signature.cert.CertificateVerifier;
import org.apache.pdfbox.examples.signature.validation.CertInformationHelper;
import org.apache.pdfbox.examples.signature.validation.CertificateProccessingException;
import org.apache.pdfbox.pdmodel.encryption.SecurityProvider;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.PDSignature;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.util.Selector;
import org.bouncycastle.util.Store;

public class CertInformationCollector {
    private static final Log LOG = LogFactory.getLog(CertInformationCollector.class);
    private static final int MAX_CERTIFICATE_CHAIN_DEPTH = 5;
    private final Set<X509Certificate> certificateSet = new HashSet<X509Certificate>();
    private final Set<String> urlSet = new HashSet<String>();
    private final JcaX509CertificateConverter certConverter = new JcaX509CertificateConverter();
    private CertSignatureInformation rootCertInfo;

    public CertSignatureInformation getLastCertInfo(PDSignature signature, String fileName) throws CertificateProccessingException, IOException {
        try (FileInputStream documentInput = new FileInputStream(fileName);){
            byte[] signatureContent = signature.getContents((InputStream)documentInput);
            CertSignatureInformation certSignatureInformation = this.getCertInfo(signatureContent);
            return certSignatureInformation;
        }
    }

    private CertSignatureInformation getCertInfo(byte[] signatureContent) throws CertificateProccessingException, IOException {
        this.rootCertInfo = new CertSignatureInformation();
        this.rootCertInfo.signatureHash = CertInformationHelper.getSha1Hash(signatureContent);
        try {
            CMSSignedData signedData = new CMSSignedData(signatureContent);
            SignerInformation signerInformation = this.processSignerStore(signedData, this.rootCertInfo);
            this.addTimestampCerts(signerInformation);
        }
        catch (CMSException e) {
            LOG.error((Object)"Error occurred getting Certificate Information from Signature", (Throwable)e);
            throw new CertificateProccessingException(e);
        }
        return this.rootCertInfo;
    }

    private void addTimestampCerts(SignerInformation signerInformation) throws IOException, CertificateProccessingException {
        AttributeTable unsignedAttributes = signerInformation.getUnsignedAttributes();
        if (unsignedAttributes == null) {
            return;
        }
        Attribute tsAttribute = unsignedAttributes.get(PKCSObjectIdentifiers.id_aa_signatureTimeStampToken);
        if (tsAttribute == null) {
            return;
        }
        ASN1Encodable obj0 = tsAttribute.getAttrValues().getObjectAt(0);
        if (!(obj0 instanceof ASN1Object)) {
            return;
        }
        ASN1Object tsSeq = (ASN1Object)obj0;
        try {
            CMSSignedData signedData = new CMSSignedData(tsSeq.getEncoded("DER"));
            this.rootCertInfo.tsaCerts = new CertSignatureInformation();
            this.processSignerStore(signedData, this.rootCertInfo.tsaCerts);
        }
        catch (CMSException e) {
            throw new IOException("Error parsing timestamp token", e);
        }
    }

    private SignerInformation processSignerStore(CMSSignedData signedData, CertSignatureInformation certInfo) throws IOException, CertificateProccessingException {
        Collection signers = signedData.getSignerInfos().getSigners();
        SignerInformation signerInformation = (SignerInformation)signers.iterator().next();
        Store certificatesStore = signedData.getCertificates();
        Collection matches = certificatesStore.getMatches((Selector)signerInformation.getSID());
        X509Certificate certificate = this.getCertFromHolder((X509CertificateHolder)matches.iterator().next());
        this.certificateSet.add(certificate);
        Collection allCerts = certificatesStore.getMatches(null);
        this.addAllCerts(allCerts);
        this.traverseChain(certificate, certInfo, 5);
        return signerInformation;
    }

    private void traverseChain(X509Certificate certificate, CertSignatureInformation certInfo, int maxDepth) throws IOException, CertificateProccessingException {
        byte[] crlExtensionValue;
        certInfo.certificate = certificate;
        byte[] authorityExtensionValue = certificate.getExtensionValue(Extension.authorityInfoAccess.getId());
        if (authorityExtensionValue != null) {
            CertInformationHelper.getAuthorityInfoExtensionValue(authorityExtensionValue, certInfo);
        }
        if (certInfo.issuerUrl != null) {
            this.getAlternativeIssuerCertificate(certInfo, maxDepth);
        }
        if ((crlExtensionValue = certificate.getExtensionValue(Extension.cRLDistributionPoints.getId())) != null) {
            certInfo.crlUrl = CertInformationHelper.getCrlUrlFromExtensionValue(crlExtensionValue);
        }
        certInfo.isSelfSigned = CertificateVerifier.isSelfSigned(certificate);
        if (maxDepth <= 0 || certInfo.isSelfSigned) {
            return;
        }
        int count = 0;
        for (X509Certificate issuer : this.certificateSet) {
            try {
                certificate.verify(issuer.getPublicKey(), SecurityProvider.getProvider());
                LOG.info((Object)("Found issuer for Cert: " + certificate.getSubjectX500Principal() + "\n" + issuer.getSubjectX500Principal()));
                certInfo.issuerCertificates.add(issuer);
                certInfo.certChain = new CertSignatureInformation();
                this.traverseChain(issuer, certInfo.certChain, maxDepth - 1);
                ++count;
            }
            catch (GeneralSecurityException generalSecurityException) {}
        }
        if (certInfo.issuerCertificates.isEmpty()) {
            throw new IOException("No Issuer Certificate found for Cert: '" + certificate.getSubjectX500Principal() + "', i.e. Cert '" + certificate.getIssuerX500Principal() + "' is missing in the chain");
        }
        if (count > 1) {
            LOG.info((Object)("Several issuers for Cert: '" + certificate.getSubjectX500Principal() + "'"));
        }
    }

    private void getAlternativeIssuerCertificate(CertSignatureInformation certInfo, int maxDepth) throws CertificateProccessingException {
        if (this.urlSet.contains(certInfo.issuerUrl)) {
            return;
        }
        this.urlSet.add(certInfo.issuerUrl);
        LOG.info((Object)("Get alternative issuer certificate from: " + certInfo.issuerUrl));
        try {
            CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
            try (InputStream in = SigUtils.openURL(certInfo.issuerUrl);){
                X509Certificate altIssuerCert = (X509Certificate)certFactory.generateCertificate(in);
                this.certificateSet.add(altIssuerCert);
                certInfo.alternativeCertChain = new CertSignatureInformation();
                this.traverseChain(altIssuerCert, certInfo.alternativeCertChain, maxDepth - 1);
            }
        }
        catch (IOException | URISyntaxException | CertificateException e) {
            LOG.error((Object)("Error getting alternative issuer certificate from " + certInfo.issuerUrl), (Throwable)e);
        }
    }

    private X509Certificate getCertFromHolder(X509CertificateHolder certificateHolder) throws CertificateProccessingException {
        try {
            return this.certConverter.getCertificate(certificateHolder);
        }
        catch (CertificateException e) {
            LOG.error((Object)"Certificate Exception getting Certificate from certHolder.", (Throwable)e);
            throw new CertificateProccessingException(e);
        }
    }

    private void addAllCerts(Collection<X509CertificateHolder> certHolders) {
        for (X509CertificateHolder certificateHolder : certHolders) {
            try {
                X509Certificate certificate = this.getCertFromHolder(certificateHolder);
                this.certificateSet.add(certificate);
            }
            catch (CertificateProccessingException e) {
                LOG.warn((Object)"Certificate Exception getting Certificate from certHolder.", (Throwable)e);
            }
        }
    }

    public void addAllCertsFromHolders(X509CertificateHolder[] certHolders) throws CertificateProccessingException {
        this.addAllCerts(Arrays.asList(certHolders));
    }

    CertSignatureInformation getCertInfo(X509Certificate certificate) throws CertificateProccessingException {
        try {
            CertSignatureInformation certSignatureInformation = new CertSignatureInformation();
            this.traverseChain(certificate, certSignatureInformation, 5);
            return certSignatureInformation;
        }
        catch (IOException ex) {
            throw new CertificateProccessingException(ex);
        }
    }

    public Set<X509Certificate> getCertificateSet() {
        return this.certificateSet;
    }

    public static class CertSignatureInformation {
        private X509Certificate certificate;
        private String signatureHash;
        private boolean isSelfSigned = false;
        private String ocspUrl;
        private String crlUrl;
        private String issuerUrl;
        private final Set<X509Certificate> issuerCertificates = new HashSet<X509Certificate>();
        private CertSignatureInformation certChain;
        private CertSignatureInformation tsaCerts;
        private CertSignatureInformation alternativeCertChain;

        public String getOcspUrl() {
            return this.ocspUrl;
        }

        public void setOcspUrl(String ocspUrl) {
            this.ocspUrl = ocspUrl;
        }

        public void setIssuerUrl(String issuerUrl) {
            this.issuerUrl = issuerUrl;
        }

        public String getCrlUrl() {
            return this.crlUrl;
        }

        public X509Certificate getCertificate() {
            return this.certificate;
        }

        public boolean isSelfSigned() {
            return this.isSelfSigned;
        }

        public Set<X509Certificate> getIssuerCertificates() {
            return this.issuerCertificates;
        }

        public String getSignatureHash() {
            return this.signatureHash;
        }

        public CertSignatureInformation getCertChain() {
            return this.certChain;
        }

        public CertSignatureInformation getTsaCerts() {
            return this.tsaCerts;
        }

        public CertSignatureInformation getAlternativeCertChain() {
            return this.alternativeCertChain;
        }
    }
}

