/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.examples.interactive.form;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType1Font;
import org.apache.pdfbox.pdmodel.font.Standard14Fonts;
import org.apache.pdfbox.pdmodel.graphics.color.PDColor;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpace;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceRGB;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationWidget;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAppearanceCharacteristicsDictionary;
import org.apache.pdfbox.pdmodel.interactive.form.PDAcroForm;
import org.apache.pdfbox.pdmodel.interactive.form.PDTerminalField;
import org.apache.pdfbox.pdmodel.interactive.form.PDTextField;

public final class CreateMultiWidgetsForm {
    private CreateMultiWidgetsForm() {
    }

    public static void main(String[] args) throws IOException {
        try (PDDocument document = new PDDocument();){
            PDPage page1 = new PDPage(PDRectangle.A4);
            document.addPage(page1);
            PDPage page2 = new PDPage(PDRectangle.A4);
            document.addPage(page2);
            PDType1Font font = new PDType1Font(Standard14Fonts.FontName.HELVETICA);
            PDResources resources = new PDResources();
            resources.put(COSName.HELV, (PDFont)font);
            PDAcroForm acroForm = new PDAcroForm(document);
            document.getDocumentCatalog().setAcroForm(acroForm);
            acroForm.setDefaultResources(resources);
            String defaultAppearanceString = "/Helv 0 Tf 0 g";
            acroForm.setDefaultAppearance(defaultAppearanceString);
            PDTextField textBox = new PDTextField(acroForm);
            textBox.setPartialName("SampleField");
            defaultAppearanceString = "/Helv 12 Tf 0 0 1 rg";
            textBox.setDefaultAppearance(defaultAppearanceString);
            acroForm.getFields().add(textBox);
            PDAnnotationWidget widget1 = new PDAnnotationWidget();
            PDRectangle rect = new PDRectangle(50.0f, 750.0f, 250.0f, 50.0f);
            widget1.setRectangle(rect);
            widget1.setPage(page1);
            widget1.setParent((PDTerminalField)textBox);
            PDAnnotationWidget widget2 = new PDAnnotationWidget();
            PDRectangle rect2 = new PDRectangle(200.0f, 650.0f, 100.0f, 50.0f);
            widget2.setRectangle(rect2);
            widget2.setPage(page2);
            widget2.setParent((PDTerminalField)textBox);
            PDAppearanceCharacteristicsDictionary fieldAppearance1 = new PDAppearanceCharacteristicsDictionary(new COSDictionary());
            fieldAppearance1.setBorderColour(new PDColor(new float[]{0.0f, 1.0f, 0.0f}, (PDColorSpace)PDDeviceRGB.INSTANCE));
            fieldAppearance1.setBackground(new PDColor(new float[]{1.0f, 1.0f, 0.0f}, (PDColorSpace)PDDeviceRGB.INSTANCE));
            widget1.setAppearanceCharacteristics(fieldAppearance1);
            PDAppearanceCharacteristicsDictionary fieldAppearance2 = new PDAppearanceCharacteristicsDictionary(new COSDictionary());
            fieldAppearance2.setBorderColour(new PDColor(new float[]{1.0f, 0.0f, 0.0f}, (PDColorSpace)PDDeviceRGB.INSTANCE));
            fieldAppearance2.setBackground(new PDColor(new float[]{0.0f, 1.0f, 0.0f}, (PDColorSpace)PDDeviceRGB.INSTANCE));
            widget2.setAppearanceCharacteristics(fieldAppearance2);
            ArrayList<PDAnnotationWidget> widgets = new ArrayList<PDAnnotationWidget>();
            widgets.add(widget1);
            widgets.add(widget2);
            textBox.setWidgets(widgets);
            widget1.setPrinted(true);
            widget2.setPrinted(true);
            page1.getAnnotations().add(widget1);
            page2.getAnnotations().add(widget2);
            textBox.setValue("Sample field");
            document.save("target/MultiWidgetsForm.pdf");
        }
    }
}

