/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.utils;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class ReflectionUtils {
    public static <T> T invokeStaticMethod(Class clz, String methodName, Object ... args) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Method[] methods;
        Method method = null;
        for (Method m : methods = clz.getDeclaredMethods()) {
            if (!methodName.equals(m.getName())) continue;
            method = m;
            break;
        }
        if (method == null) {
            throw new NoSuchMethodException(methodName);
        }
        return ReflectionUtils.invokeStaticMethod(method, args);
    }

    public static <T> T invokeStaticMethod(Method method, Object ... args) throws InvocationTargetException, IllegalAccessException {
        return (T)method.invoke(null, args);
    }

    public static Method getMethod(Class<?> clz, String methodName, int argSize) throws NoSuchMethodException {
        Method[] methods;
        Method method = null;
        for (Method m : methods = clz.getMethods()) {
            if (!methodName.equals(m.getName()) || m.getParameterTypes().length != argSize) continue;
            method = m;
            break;
        }
        if (method == null) {
            throw new NoSuchMethodException(methodName);
        }
        return method;
    }

    public static <T> T getPrivateFieldValue(Object obj, String fieldName) throws NoSuchFieldException, IllegalAccessException {
        for (Class<?> clazz = obj.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            try {
                Field field = clazz.getDeclaredField(fieldName);
                field.setAccessible(true);
                return (T)field.get(obj);
            }
            catch (NoSuchFieldException e) {
                continue;
            }
        }
        throw new NoSuchFieldException(fieldName);
    }
}

