/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.table.format;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.data.BinaryRowWriter;
import org.apache.paimon.data.BinaryWriter;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.FileStatus;
import org.apache.paimon.fs.Path;
import org.apache.paimon.manifest.PartitionEntry;
import org.apache.paimon.partition.PartitionPredicate;
import org.apache.paimon.predicate.Predicate;
import org.apache.paimon.table.FormatTable;
import org.apache.paimon.table.format.FormatDataSplit;
import org.apache.paimon.table.source.InnerTableScan;
import org.apache.paimon.table.source.Split;
import org.apache.paimon.table.source.TableScan;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.Pair;
import org.apache.paimon.utils.PartitionPathUtils;
import org.apache.paimon.utils.TypeUtils;

public class FormatTableScan
implements InnerTableScan {
    private final FormatTable table;
    @Nullable
    private PartitionPredicate partitionFilter;
    @Nullable
    private Integer limit;

    public FormatTableScan(FormatTable table, @Nullable PartitionPredicate partitionFilter, @Nullable Integer limit) {
        this.table = table;
        this.partitionFilter = partitionFilter;
        this.limit = limit;
    }

    @Override
    public InnerTableScan withPartitionFilter(PartitionPredicate partitionPredicate) {
        this.partitionFilter = partitionPredicate;
        return this;
    }

    @Override
    public TableScan.Plan plan() {
        return new FormatTableScanPlan();
    }

    @Override
    public List<PartitionEntry> listPartitionEntries() {
        List<Pair<LinkedHashMap<String, String>, Path>> partition2Paths = PartitionPathUtils.searchPartSpecAndPaths(this.table.fileIO(), new Path(this.table.location()), this.table.partitionKeys().size());
        ArrayList<PartitionEntry> partitionEntries = new ArrayList<PartitionEntry>();
        for (Pair<LinkedHashMap<String, String>, Path> partition2Path : partition2Paths) {
            BinaryRow row = this.createPartitionRow(partition2Path.getKey());
            partitionEntries.add(new PartitionEntry(row, -1L, -1L, -1L, -1L));
        }
        return partitionEntries;
    }

    @Override
    public InnerTableScan withFilter(Predicate predicate) {
        throw new UnsupportedOperationException("Filter is not supported for FormatTable.");
    }

    public static boolean isDataFileName(String fileName) {
        return fileName != null && !fileName.startsWith(".") && !fileName.startsWith("_");
    }

    private BinaryRow createPartitionRow(LinkedHashMap<String, String> partitionSpec) {
        RowType partitionRowType = this.table.partitionType();
        List<DataField> fields = partitionRowType.getFields();
        ArrayList<BinaryWriter.ValueSetter> valueSetters = new ArrayList<BinaryWriter.ValueSetter>();
        for (DataField field : fields) {
            valueSetters.add(BinaryWriter.createValueSetter(field.type()));
        }
        BinaryRow binaryRow = new BinaryRow(fields.size());
        BinaryRowWriter binaryRowWriter = new BinaryRowWriter(binaryRow);
        for (int i = 0; i < fields.size(); ++i) {
            String fieldName = fields.get(i).name();
            String partitionValue = partitionSpec.get(fieldName);
            if (partitionValue == null || partitionValue.equals(this.table.defaultPartName())) {
                binaryRowWriter.setNullAt(i);
                continue;
            }
            Object value = TypeUtils.castFromString(partitionValue, fields.get(i).type());
            ((BinaryWriter.ValueSetter)valueSetters.get(i)).setValue(binaryRowWriter, i, value);
        }
        binaryRowWriter.complete();
        return binaryRow;
    }

    private List<Split> getSplits(FileIO fileIO, Path path, BinaryRow partition) throws IOException {
        FileStatus[] files;
        ArrayList<Split> splits = new ArrayList<Split>();
        for (FileStatus file : files = fileIO.listFiles(path, true)) {
            if (!FormatTableScan.isDataFileName(file.getPath().getName())) continue;
            FormatDataSplit split = new FormatDataSplit(file.getPath(), 0L, file.getLen(), partition);
            splits.add(split);
        }
        return splits;
    }

    private class FormatTableScanPlan
    implements TableScan.Plan {
        private FormatTableScanPlan() {
        }

        @Override
        public List<Split> splits() {
            ArrayList<Split> splits = new ArrayList<Split>();
            try {
                FileIO fileIO = FormatTableScan.this.table.fileIO();
                if (!FormatTableScan.this.table.partitionKeys().isEmpty()) {
                    List<Pair<LinkedHashMap<String, String>, Path>> partition2Paths = PartitionPathUtils.searchPartSpecAndPaths(fileIO, new Path(FormatTableScan.this.table.location()), FormatTableScan.this.table.partitionKeys().size());
                    for (Pair<LinkedHashMap<String, String>, Path> partition2Path : partition2Paths) {
                        LinkedHashMap<String, String> partitionSpec = partition2Path.getKey();
                        BinaryRow partitionRow = FormatTableScan.this.createPartitionRow(partitionSpec);
                        if (FormatTableScan.this.partitionFilter != null && !FormatTableScan.this.partitionFilter.test(partitionRow)) continue;
                        splits.addAll(FormatTableScan.this.getSplits(fileIO, partition2Path.getValue(), partitionRow));
                    }
                } else {
                    splits.addAll(FormatTableScan.this.getSplits(fileIO, new Path(FormatTableScan.this.table.location()), null));
                }
                if (FormatTableScan.this.limit != null) {
                    if (FormatTableScan.this.limit <= 0) {
                        return new ArrayList<Split>();
                    }
                    if (splits.size() > FormatTableScan.this.limit) {
                        return splits.subList(0, FormatTableScan.this.limit);
                    }
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to scan files", e);
            }
            return splits;
        }
    }
}

