/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.schema;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.annotation.VisibleForTesting;
import org.apache.paimon.casting.CastExecutors;
import org.apache.paimon.catalog.Catalog;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.schema.Schema;
import org.apache.paimon.schema.SchemaChange;
import org.apache.paimon.schema.SchemaMergingUtils;
import org.apache.paimon.schema.SchemaValidation;
import org.apache.paimon.schema.TableSchema;
import org.apache.paimon.shade.guava30.com.google.common.collect.FluentIterable;
import org.apache.paimon.shade.guava30.com.google.common.collect.ImmutableList;
import org.apache.paimon.shade.guava30.com.google.common.collect.Iterables;
import org.apache.paimon.shade.guava30.com.google.common.collect.Maps;
import org.apache.paimon.shade.guava30.com.google.common.collect.Streams;
import org.apache.paimon.table.FileStoreTableFactory;
import org.apache.paimon.types.ArrayType;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypeCasts;
import org.apache.paimon.types.MapType;
import org.apache.paimon.types.ReassignFieldId;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.BranchManager;
import org.apache.paimon.utils.DefaultValueUtils;
import org.apache.paimon.utils.FileUtils;
import org.apache.paimon.utils.LazyField;
import org.apache.paimon.utils.Preconditions;
import org.apache.paimon.utils.SnapshotManager;
import org.apache.paimon.utils.StringUtils;

@ThreadSafe
public class SchemaManager
implements Serializable {
    private static final String SCHEMA_PREFIX = "schema-";
    private final FileIO fileIO;
    private final Path tableRoot;
    private final String branch;

    public SchemaManager(FileIO fileIO, Path tableRoot) {
        this(fileIO, tableRoot, "main");
    }

    public SchemaManager(FileIO fileIO, Path tableRoot, String branch) {
        this.fileIO = fileIO;
        this.tableRoot = tableRoot;
        this.branch = BranchManager.normalizeBranch(branch);
    }

    public SchemaManager copyWithBranch(String branchName) {
        return new SchemaManager(this.fileIO, this.tableRoot, branchName);
    }

    public Optional<TableSchema> latest() {
        try {
            return FileUtils.listVersionedFiles(this.fileIO, this.schemaDirectory(), SCHEMA_PREFIX).reduce(Math::max).map(this::schema);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public TableSchema latestOrThrow(String message) {
        return this.latest().orElseThrow(() -> new RuntimeException(message));
    }

    public long earliestCreationTime() {
        try {
            long earliest = 0L;
            if (!this.schemaExists(0L)) {
                Optional<Long> min = FileUtils.listVersionedFiles(this.fileIO, this.schemaDirectory(), SCHEMA_PREFIX).reduce(Math::min);
                Preconditions.checkArgument(min.isPresent());
                earliest = min.get();
            }
            Path schemaPath = this.toSchemaPath(earliest);
            return this.fileIO.getFileStatus(schemaPath).getModificationTime();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public List<TableSchema> listAll() {
        return this.listAllIds().stream().map(this::schema).collect(Collectors.toList());
    }

    public List<Long> listAllIds() {
        try {
            return FileUtils.listVersionedFiles(this.fileIO, this.schemaDirectory(), SCHEMA_PREFIX).collect(Collectors.toList());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public TableSchema createTable(Schema schema) throws Exception {
        return this.createTable(schema, false);
    }

    public TableSchema createTable(Schema schema, boolean externalTable) throws Exception {
        TableSchema newSchema;
        boolean success;
        do {
            Optional<TableSchema> latest;
            if ((latest = this.latest()).isPresent()) {
                TableSchema latestSchema = latest.get();
                if (externalTable) {
                    this.checkSchemaForExternalTable(latestSchema.toSchema(), schema);
                    return latestSchema;
                }
                throw new IllegalStateException("Schema in filesystem exists, creation is not allowed.");
            }
            newSchema = TableSchema.create(0L, schema);
            FileStoreTableFactory.create(this.fileIO, this.tableRoot, newSchema).store();
        } while (!(success = this.commit(newSchema)));
        return newSchema;
    }

    private void checkSchemaForExternalTable(Schema existsSchema, Schema newSchema) {
        if (!newSchema.fields().isEmpty() && !newSchema.rowType().equalsIgnoreFieldId(existsSchema.rowType()) || !newSchema.partitionKeys().isEmpty() && !Objects.equals(newSchema.partitionKeys(), existsSchema.partitionKeys()) || !newSchema.primaryKeys().isEmpty() && !Objects.equals(newSchema.primaryKeys(), existsSchema.primaryKeys())) {
            throw new RuntimeException("New schema is not equal to exists schema, new schema: " + newSchema + ", exists schema: " + existsSchema);
        }
        Map<String, String> existsOptions = existsSchema.options();
        Map<String, String> newOptions = newSchema.options();
        newOptions.forEach((key, value) -> {
            if (!(key.equals("owner") || key.equals(CoreOptions.PATH.key()) || existsOptions.containsKey(key) && ((String)existsOptions.get(key)).equals(value))) {
                throw new RuntimeException("New schema's options are not equal to the exists schema's, new schema: " + newOptions + ", exists schema: " + existsOptions);
            }
        });
    }

    public TableSchema commitChanges(SchemaChange ... changes) throws Exception {
        return this.commitChanges(Arrays.asList(changes));
    }

    /*
     * Exception decompiling
     */
    public TableSchema commitChanges(List<SchemaChange> changes) throws Catalog.TableNotExistException, Catalog.ColumnAlreadyExistException, Catalog.ColumnNotExistException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[DOLOOP]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static TableSchema generateTableSchema(TableSchema oldTableSchema, List<SchemaChange> changes, LazyField<Boolean> hasSnapshots, final LazyField<Identifier> lazyIdentifier) throws Catalog.ColumnAlreadyExistException, Catalog.ColumnNotExistException {
        HashMap<String, String> oldOptions = new HashMap<String, String>(oldTableSchema.options());
        HashMap<String, String> newOptions = new HashMap<String, String>(oldTableSchema.options());
        boolean disableNullToNotNull = Boolean.parseBoolean(oldOptions.getOrDefault(CoreOptions.DISABLE_ALTER_COLUMN_NULL_TO_NOT_NULL.key(), CoreOptions.DISABLE_ALTER_COLUMN_NULL_TO_NOT_NULL.defaultValue().toString()));
        boolean disableExplicitTypeCasting = Boolean.parseBoolean(oldOptions.getOrDefault(CoreOptions.DISABLE_EXPLICIT_TYPE_CASTING.key(), CoreOptions.DISABLE_EXPLICIT_TYPE_CASTING.defaultValue().toString()));
        ArrayList<DataField> newFields = new ArrayList<DataField>(oldTableSchema.fields());
        AtomicInteger highestFieldId = new AtomicInteger(oldTableSchema.highestFieldId());
        String newComment = oldTableSchema.comment();
        for (SchemaChange change : changes) {
            SchemaChange update;
            SchemaChange.Move move;
            if (change instanceof SchemaChange.SetOption) {
                SchemaChange.SetOption setOption = (SchemaChange.SetOption)change;
                if (hasSnapshots.get().booleanValue()) {
                    SchemaManager.checkAlterTableOption(setOption.key(), (String)oldOptions.get(setOption.key()), setOption.value(), false);
                }
                newOptions.put(setOption.key(), setOption.value());
                continue;
            }
            if (change instanceof SchemaChange.RemoveOption) {
                SchemaChange.RemoveOption removeOption = (SchemaChange.RemoveOption)change;
                if (hasSnapshots.get().booleanValue()) {
                    SchemaManager.checkResetTableOption(removeOption.key());
                }
                newOptions.remove(removeOption.key());
                continue;
            }
            if (change instanceof SchemaChange.UpdateComment) {
                SchemaChange.UpdateComment updateComment = (SchemaChange.UpdateComment)change;
                newComment = updateComment.comment();
                continue;
            }
            if (change instanceof SchemaChange.AddColumn) {
                final SchemaChange.AddColumn addColumn = (SchemaChange.AddColumn)change;
                move = addColumn.move();
                Preconditions.checkArgument(addColumn.dataType().isNullable(), "Column %s cannot specify NOT NULL in the %s table.", String.join((CharSequence)".", addColumn.fieldNames()), lazyIdentifier.get().getFullName());
                final int id = highestFieldId.incrementAndGet();
                final DataType dataType = ReassignFieldId.reassign(addColumn.dataType(), highestFieldId);
                new NestedColumnModifier(addColumn.fieldNames(), lazyIdentifier){

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    @Override
                    protected void updateLastColumn(int depth, List<DataField> newFields, String fieldName) throws Catalog.ColumnAlreadyExistException, Catalog.ColumnNotExistException {
                        this.assertColumnNotExists(newFields, fieldName, lazyIdentifier);
                        DataField dataField = new DataField(id, fieldName, dataType, addColumn.description());
                        HashMap<String, Integer> map = new HashMap<String, Integer>();
                        for (int i = 0; i < newFields.size(); ++i) {
                            map.put(newFields.get(i).name(), i);
                        }
                        if (null != move) {
                            int fieldIndex;
                            if (move.type().equals((Object)SchemaChange.Move.MoveType.FIRST)) {
                                newFields.add(0, dataField);
                                return;
                            } else if (move.type().equals((Object)SchemaChange.Move.MoveType.AFTER)) {
                                if (!map.containsKey(move.referenceFieldName())) throw new Catalog.ColumnNotExistException((Identifier)lazyIdentifier.get(), move.referenceFieldName());
                                fieldIndex = (Integer)map.get(move.referenceFieldName());
                                newFields.add(fieldIndex + 1, dataField);
                                return;
                            } else if (move.type().equals((Object)SchemaChange.Move.MoveType.BEFORE)) {
                                if (!map.containsKey(move.referenceFieldName())) throw new Catalog.ColumnNotExistException((Identifier)lazyIdentifier.get(), move.referenceFieldName());
                                fieldIndex = (Integer)map.get(move.referenceFieldName());
                                newFields.add(fieldIndex, dataField);
                                return;
                            } else {
                                if (!move.type().equals((Object)SchemaChange.Move.MoveType.LAST)) throw new UnsupportedOperationException("Unsupported move type: " + (Object)((Object)move.type()));
                                newFields.add(dataField);
                            }
                            return;
                        } else {
                            newFields.add(dataField);
                        }
                    }
                }.updateIntermediateColumn(newFields, 0);
                continue;
            }
            if (change instanceof SchemaChange.RenameColumn) {
                final SchemaChange.RenameColumn rename = (SchemaChange.RenameColumn)change;
                SchemaManager.assertNotUpdatingPartitionKeys(oldTableSchema, rename.fieldNames(), "rename");
                new NestedColumnModifier(rename.fieldNames(), lazyIdentifier){

                    @Override
                    protected void updateLastColumn(int depth, List<DataField> newFields, String fieldName) throws Catalog.ColumnNotExistException, Catalog.ColumnAlreadyExistException {
                        this.assertColumnExists(newFields, fieldName, lazyIdentifier);
                        this.assertColumnNotExists(newFields, rename.newName(), lazyIdentifier);
                        for (int i = 0; i < newFields.size(); ++i) {
                            DataField field = newFields.get(i);
                            if (!field.name().equals(fieldName)) continue;
                            DataField newField = new DataField(field.id(), rename.newName(), field.type(), field.description(), field.defaultValue());
                            newFields.set(i, newField);
                            return;
                        }
                    }
                }.updateIntermediateColumn(newFields, 0);
                continue;
            }
            if (change instanceof SchemaChange.DropColumn) {
                SchemaChange.DropColumn drop = (SchemaChange.DropColumn)change;
                SchemaManager.dropColumnValidation(oldTableSchema, drop);
                new NestedColumnModifier(drop.fieldNames(), lazyIdentifier){

                    @Override
                    protected void updateLastColumn(int depth, List<DataField> newFields, String fieldName) throws Catalog.ColumnNotExistException {
                        this.assertColumnExists(newFields, fieldName, lazyIdentifier);
                        newFields.removeIf(f -> f.name().equals(fieldName));
                        if (newFields.isEmpty()) {
                            throw new IllegalArgumentException("Cannot drop all fields in table");
                        }
                    }
                }.updateIntermediateColumn(newFields, 0);
                continue;
            }
            if (change instanceof SchemaChange.UpdateColumnType) {
                update = (SchemaChange.UpdateColumnType)change;
                SchemaManager.assertNotUpdatingPartitionKeys(oldTableSchema, ((SchemaChange.UpdateColumnType)update).fieldNames(), "update");
                SchemaManager.assertNotUpdatingPrimaryKeys(oldTableSchema, ((SchemaChange.UpdateColumnType)update).fieldNames(), "update");
                SchemaManager.updateNestedColumn(newFields, ((SchemaChange.UpdateColumnType)update).fieldNames(), (arg_0, arg_1) -> SchemaManager.lambda$generateTableSchema$5((SchemaChange.UpdateColumnType)update, disableNullToNotNull, disableExplicitTypeCasting, arg_0, arg_1), lazyIdentifier);
                continue;
            }
            if (change instanceof SchemaChange.UpdateColumnNullability) {
                update = (SchemaChange.UpdateColumnNullability)change;
                if (((SchemaChange.UpdateColumnNullability)update).newNullability()) {
                    SchemaManager.assertNotUpdatingPrimaryKeys(oldTableSchema, ((SchemaChange.UpdateColumnNullability)update).fieldNames(), "change nullability of");
                }
                SchemaManager.updateNestedColumn(newFields, ((SchemaChange.UpdateColumnNullability)update).fieldNames(), (arg_0, arg_1) -> SchemaManager.lambda$generateTableSchema$6((SchemaChange.UpdateColumnNullability)update, disableNullToNotNull, arg_0, arg_1), lazyIdentifier);
                continue;
            }
            if (change instanceof SchemaChange.UpdateColumnComment) {
                update = (SchemaChange.UpdateColumnComment)change;
                SchemaManager.updateNestedColumn(newFields, ((SchemaChange.UpdateColumnComment)update).fieldNames(), (arg_0, arg_1) -> SchemaManager.lambda$generateTableSchema$7((SchemaChange.UpdateColumnComment)update, arg_0, arg_1), lazyIdentifier);
                continue;
            }
            if (change instanceof SchemaChange.UpdateColumnPosition) {
                update = (SchemaChange.UpdateColumnPosition)change;
                move = ((SchemaChange.UpdateColumnPosition)update).move();
                SchemaManager.applyMove(newFields, move);
                continue;
            }
            if (change instanceof SchemaChange.UpdateColumnDefaultValue) {
                update = (SchemaChange.UpdateColumnDefaultValue)change;
                SchemaManager.updateNestedColumn(newFields, ((SchemaChange.UpdateColumnDefaultValue)update).fieldNames(), (arg_0, arg_1) -> SchemaManager.lambda$generateTableSchema$8((SchemaChange.UpdateColumnDefaultValue)update, arg_0, arg_1), lazyIdentifier);
                continue;
            }
            throw new UnsupportedOperationException("Unsupported change: " + change.getClass());
        }
        Schema newSchema = new Schema(newFields, oldTableSchema.partitionKeys(), SchemaManager.applyNotNestedColumnRename(oldTableSchema.primaryKeys(), Iterables.filter(changes, SchemaChange.RenameColumn.class)), SchemaManager.applyRenameColumnsToOptions(newOptions, changes), newComment);
        return new TableSchema(oldTableSchema.id() + 1L, newSchema.fields(), highestFieldId.get(), newSchema.partitionKeys(), newSchema.primaryKeys(), newSchema.options(), newSchema.comment());
    }

    private static DataType getRootType(DataType type, int currDepth, int maxDepth) {
        if (currDepth == maxDepth - 1) {
            return type;
        }
        switch (type.getTypeRoot()) {
            case ARRAY: {
                return SchemaManager.getRootType(((ArrayType)type).getElementType(), currDepth + 1, maxDepth);
            }
            case MAP: {
                return SchemaManager.getRootType(((MapType)type).getValueType(), currDepth + 1, maxDepth);
            }
        }
        return type;
    }

    private static DataType getArrayMapTypeWithTargetTypeRoot(DataType source, DataType target, int currDepth, int maxDepth) {
        if (currDepth == maxDepth - 1) {
            return target;
        }
        switch (source.getTypeRoot()) {
            case ARRAY: {
                return new ArrayType(source.isNullable(), SchemaManager.getArrayMapTypeWithTargetTypeRoot(((ArrayType)source).getElementType(), target, currDepth + 1, maxDepth));
            }
            case MAP: {
                return new MapType(source.isNullable(), ((MapType)source).getKeyType(), SchemaManager.getArrayMapTypeWithTargetTypeRoot(((MapType)source).getValueType(), target, currDepth + 1, maxDepth));
            }
        }
        return target;
    }

    private static void assertNullabilityChange(boolean oldNullability, boolean newNullability, String fieldName, boolean disableNullToNotNull) {
        if (disableNullToNotNull && oldNullability && !newNullability) {
            throw new UnsupportedOperationException(String.format("Cannot update column type from nullable to non nullable for %s. You can set table configuration option 'alter-column-null-to-not-null.disabled' = 'false' to allow converting null columns to not null", fieldName));
        }
    }

    public static void applyMove(List<DataField> newFields, SchemaChange.Move move) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (int i = 0; i < newFields.size(); ++i) {
            map.put(newFields.get(i).name(), i);
        }
        int fieldIndex = map.getOrDefault(move.fieldName(), -1);
        if (fieldIndex == -1) {
            throw new IllegalArgumentException("Field name not found: " + move.fieldName());
        }
        switch (move.type()) {
            case FIRST: {
                SchemaManager.checkMoveIndexEqual(move, fieldIndex, 0);
                SchemaManager.moveField(newFields, fieldIndex, 0);
                return;
            }
            case LAST: {
                SchemaManager.checkMoveIndexEqual(move, fieldIndex, newFields.size() - 1);
                SchemaManager.moveField(newFields, fieldIndex, newFields.size() - 1);
                return;
            }
        }
        Integer refIndex = map.getOrDefault(move.referenceFieldName(), -1);
        if (refIndex == -1) {
            throw new IllegalArgumentException("Reference field name not found: " + move.referenceFieldName());
        }
        SchemaManager.checkMoveIndexEqual(move, fieldIndex, refIndex);
        int targetIndex = refIndex;
        if (move.type() == SchemaChange.Move.MoveType.AFTER && fieldIndex > refIndex) {
            ++targetIndex;
        }
        if (move.type() == SchemaChange.Move.MoveType.BEFORE && fieldIndex < refIndex) {
            --targetIndex;
        }
        if (targetIndex > newFields.size() - 1) {
            targetIndex = newFields.size() - 1;
        }
        SchemaManager.moveField(newFields, fieldIndex, targetIndex);
    }

    private static void moveField(List<DataField> newFields, int fromIndex, int toIndex) {
        if (fromIndex < 0 || fromIndex >= newFields.size() || toIndex < 0) {
            return;
        }
        DataField fieldToMove = newFields.remove(fromIndex);
        newFields.add(toIndex, fieldToMove);
    }

    private static void checkMoveIndexEqual(SchemaChange.Move move, int fieldIndex, int refIndex) {
        if (refIndex == fieldIndex) {
            throw new UnsupportedOperationException(String.format("Cannot move itself for column %s", move.fieldName()));
        }
    }

    public boolean mergeSchema(RowType rowType, boolean allowExplicitCast) {
        TableSchema update;
        TableSchema current = this.latest().orElseThrow(() -> new RuntimeException("It requires that the current schema to exist when calling 'mergeSchema'"));
        if (current.equals(update = SchemaMergingUtils.mergeSchemas(current, rowType, allowExplicitCast))) {
            return false;
        }
        try {
            return this.commit(update);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to commit the schema.", e);
        }
    }

    private static Map<String, String> applyRenameColumnsToOptions(Map<String, String> options, Iterable<SchemaChange> changes) {
        String sequenceFieldsStr;
        FluentIterable<SchemaChange.RenameColumn> renameColumns = FluentIterable.from(changes).filter(SchemaChange.RenameColumn.class);
        if (Iterables.isEmpty(renameColumns)) {
            return options;
        }
        HashMap<String, String> newOptions = Maps.newHashMap(options);
        Map<String, String> renameMappings = Streams.stream(renameColumns).collect(Collectors.toMap(rename -> rename.fieldNames()[0], SchemaChange.RenameColumn::newName));
        String bucketKeysStr = options.get(CoreOptions.BUCKET_KEY.key());
        if (!StringUtils.isNullOrWhitespaceOnly(bucketKeysStr)) {
            List<String> bucketColumns = Arrays.asList(bucketKeysStr.split(","));
            List<String> newBucketColumns = SchemaManager.applyNotNestedColumnRename(bucketColumns, renameMappings);
            newOptions.put(CoreOptions.BUCKET_KEY.key(), String.join((CharSequence)",", newBucketColumns));
        }
        if (!StringUtils.isNullOrWhitespaceOnly(sequenceFieldsStr = options.get(CoreOptions.SEQUENCE_FIELD.key()))) {
            List<String> sequenceFields = Arrays.asList(sequenceFieldsStr.split(","));
            List<String> newSequenceFields = SchemaManager.applyNotNestedColumnRename(sequenceFields, renameMappings);
            newOptions.put(CoreOptions.SEQUENCE_FIELD.key(), String.join((CharSequence)",", newSequenceFields));
        }
        ImmutableList<Function<String, String>> fieldNameToOptionKeys = ImmutableList.of(fieldName -> "fields." + fieldName + "." + "aggregate-function", fieldName -> "fields." + fieldName + "." + "ignore-retract", fieldName -> "fields." + fieldName + "." + "distinct", fieldName -> "fields." + fieldName + "." + "list-agg-delimiter");
        for (SchemaChange.RenameColumn rename2 : renameColumns) {
            String fieldName2 = rename2.fieldNames()[0];
            String newFieldName = rename2.newName();
            for (Function function : fieldNameToOptionKeys) {
                String key = (String)function.apply(fieldName2);
                if (!newOptions.containsKey(key)) continue;
                String value = (String)newOptions.remove(key);
                newOptions.put((String)function.apply(newFieldName), value);
            }
        }
        for (String key : options.keySet()) {
            if (!key.startsWith("fields")) continue;
            String matchedSuffix = null;
            if (key.endsWith("sequence-group")) {
                matchedSuffix = "sequence-group";
            } else if (key.endsWith("nested-key")) {
                matchedSuffix = "nested-key";
            }
            if (matchedSuffix == null) continue;
            String keyFieldsStr = key.substring("fields".length() + 1, key.length() - matchedSuffix.length() - 1);
            List<String> keyFields = Arrays.asList(keyFieldsStr.split(","));
            List<String> list = SchemaManager.applyNotNestedColumnRename(keyFields, renameMappings);
            String valueFieldsStr = (String)newOptions.remove(key);
            List<String> valueFields = Arrays.asList(valueFieldsStr.split(","));
            List<String> newValueFields = SchemaManager.applyNotNestedColumnRename(valueFields, renameMappings);
            newOptions.put("fields." + String.join((CharSequence)",", list) + "." + matchedSuffix, String.join((CharSequence)",", newValueFields));
        }
        return newOptions;
    }

    private static List<String> applyNotNestedColumnRename(List<String> columns, Iterable<SchemaChange.RenameColumn> renames) {
        if (Iterables.isEmpty(renames)) {
            return columns;
        }
        HashMap<String, String> columnNames = Maps.newHashMap();
        for (SchemaChange.RenameColumn renameColumn : renames) {
            if (renameColumn.fieldNames().length != 1) continue;
            columnNames.put(renameColumn.fieldNames()[0], renameColumn.newName());
        }
        return SchemaManager.applyNotNestedColumnRename(columns, columnNames);
    }

    private static List<String> applyNotNestedColumnRename(List<String> columns, Map<String, String> renameMapping) {
        return columns.stream().map(column -> renameMapping.getOrDefault(column, (String)column)).collect(Collectors.toList());
    }

    private static void dropColumnValidation(TableSchema schema, SchemaChange.DropColumn change) {
        if (change.fieldNames().length > 1) {
            return;
        }
        String columnToDrop = change.fieldNames()[0];
        if (schema.partitionKeys().contains(columnToDrop) || schema.primaryKeys().contains(columnToDrop)) {
            throw new UnsupportedOperationException(String.format("Cannot drop partition key or primary key: [%s]", columnToDrop));
        }
    }

    private static void assertNotUpdatingPartitionKeys(TableSchema schema, String[] fieldNames, String operation) {
        if (fieldNames.length > 1) {
            return;
        }
        String fieldName = fieldNames[0];
        if (schema.partitionKeys().contains(fieldName)) {
            throw new UnsupportedOperationException(String.format("Cannot %s partition column: [%s]", operation, fieldName));
        }
    }

    private static void assertNotUpdatingPrimaryKeys(TableSchema schema, String[] fieldNames, String operation) {
        if (fieldNames.length > 1) {
            return;
        }
        String fieldName = fieldNames[0];
        if (schema.primaryKeys().contains(fieldName)) {
            throw new UnsupportedOperationException(String.format("Cannot %s primary key", operation));
        }
    }

    private static void updateNestedColumn(List<DataField> newFields, final String[] updateFieldNames, final BiFunction<DataField, Integer, DataField> updateFunc, final LazyField<Identifier> lazyIdentifier) throws Catalog.ColumnNotExistException, Catalog.ColumnAlreadyExistException {
        new NestedColumnModifier(updateFieldNames, lazyIdentifier){

            @Override
            protected void updateLastColumn(int depth, List<DataField> newFields, String fieldName) throws Catalog.ColumnNotExistException {
                for (int i = 0; i < newFields.size(); ++i) {
                    DataField field = newFields.get(i);
                    if (!field.name().equals(fieldName)) continue;
                    newFields.set(i, (DataField)updateFunc.apply(field, depth));
                    return;
                }
                throw new Catalog.ColumnNotExistException((Identifier)lazyIdentifier.get(), String.join((CharSequence)".", updateFieldNames));
            }
        }.updateIntermediateColumn(newFields, 0);
    }

    @VisibleForTesting
    public boolean commit(TableSchema newSchema) throws Exception {
        SchemaValidation.validateTableSchema(newSchema);
        SchemaValidation.validateFallbackBranch(this, newSchema);
        Path schemaPath = this.toSchemaPath(newSchema.id());
        return this.fileIO.tryToWriteAtomic(schemaPath, newSchema.toString());
    }

    public TableSchema schema(long id) {
        return SchemaManager.fromPath(this.fileIO, this.toSchemaPath(id));
    }

    public boolean schemaExists(long id) {
        Path path = this.toSchemaPath(id);
        try {
            return this.fileIO.exists(path);
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Failed to determine if schema '%s' exists in path %s.", id, path), e);
        }
    }

    private String branchPath() {
        return BranchManager.branchPath(this.tableRoot, this.branch);
    }

    public Path schemaDirectory() {
        return new Path(this.branchPath() + "/schema");
    }

    @VisibleForTesting
    public Path toSchemaPath(long schemaId) {
        return new Path(this.branchPath() + "/schema/" + SCHEMA_PREFIX + schemaId);
    }

    public List<Path> schemaPaths(Predicate<Long> predicate) throws IOException {
        return FileUtils.listVersionedFiles(this.fileIO, this.schemaDirectory(), SCHEMA_PREFIX).filter(predicate).map(this::toSchemaPath).collect(Collectors.toList());
    }

    public void deleteSchema(long schemaId) {
        this.fileIO.deleteQuietly(this.toSchemaPath(schemaId));
    }

    public static void checkAlterTableOption(String key, @Nullable String oldValue, String newValue, boolean fromDynamicOptions) {
        if (CoreOptions.IMMUTABLE_OPTIONS.contains(key)) {
            throw new UnsupportedOperationException(String.format("Change '%s' is not supported yet.", key));
        }
        if (CoreOptions.BUCKET.key().equals(key)) {
            int oldBucket = oldValue == null ? CoreOptions.BUCKET.defaultValue() : Integer.parseInt(oldValue);
            int newBucket = Integer.parseInt(newValue);
            if (fromDynamicOptions) {
                throw new UnsupportedOperationException("Cannot change bucket number through dynamic options. You might need to rescale bucket.");
            }
            if (oldBucket == -1) {
                throw new UnsupportedOperationException("Cannot change bucket when it is -1.");
            }
            if (newBucket == -1) {
                throw new UnsupportedOperationException("Cannot change bucket to -1.");
            }
            if (oldBucket == -2) {
                throw new UnsupportedOperationException("Cannot change bucket for postpone bucket tables.");
            }
        }
    }

    public static void checkResetTableOption(String key) {
        if (CoreOptions.IMMUTABLE_OPTIONS.contains(key)) {
            throw new UnsupportedOperationException(String.format("Change '%s' is not supported yet.", key));
        }
        if (CoreOptions.BUCKET.key().equals(key)) {
            throw new UnsupportedOperationException(String.format("Cannot reset %s.", key));
        }
    }

    public static void checkAlterTablePath(String key) {
        if (CoreOptions.PATH.key().equalsIgnoreCase(key)) {
            throw new UnsupportedOperationException("Change path is not supported yet.");
        }
    }

    public static Identifier identifierFromPath(String tablePath, boolean ignoreIfUnknownDatabase) {
        return SchemaManager.identifierFromPath(tablePath, ignoreIfUnknownDatabase, null);
    }

    public static Identifier identifierFromPath(String tablePath, boolean ignoreIfUnknownDatabase, @Nullable String branchName) {
        String[] paths;
        if ("main".equals(branchName)) {
            branchName = null;
        }
        if ((paths = tablePath.split("/")).length < 2) {
            if (!ignoreIfUnknownDatabase) {
                throw new IllegalArgumentException(String.format("Path '%s' is not a valid path, please use catalog table path instead: 'warehouse_path/your_database.db/your_table'.", tablePath));
            }
            return new Identifier("unknown", paths[0]);
        }
        String database = paths[paths.length - 2];
        int index = database.lastIndexOf(".db");
        if (index == -1) {
            if (!ignoreIfUnknownDatabase) {
                throw new IllegalArgumentException(String.format("Path '%s' is not a valid path, please use catalog table path instead: 'warehouse_path/your_database.db/your_table'.", tablePath));
            }
            return new Identifier("unknown", paths[paths.length - 1], branchName, null);
        }
        database = database.substring(0, index);
        return new Identifier(database, paths[paths.length - 1], branchName, null);
    }

    public static TableSchema fromPath(FileIO fileIO, Path path) {
        try {
            return SchemaManager.tryFromPath(fileIO, path);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static TableSchema tryFromPath(FileIO fileIO, Path path) throws FileNotFoundException {
        try {
            return TableSchema.fromJson(fileIO.readFileUtf8(path));
        }
        catch (FileNotFoundException e) {
            throw e;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static /* synthetic */ DataField lambda$generateTableSchema$8(SchemaChange.UpdateColumnDefaultValue update, DataField field, Integer depth) {
        DefaultValueUtils.validateDefaultValue(field.type(), update.newDefaultValue());
        return new DataField(field.id(), field.name(), field.type(), field.description(), update.newDefaultValue());
    }

    private static /* synthetic */ DataField lambda$generateTableSchema$7(SchemaChange.UpdateColumnComment update, DataField field, Integer depth) {
        return new DataField(field.id(), field.name(), field.type(), update.newDescription(), field.defaultValue());
    }

    private static /* synthetic */ DataField lambda$generateTableSchema$6(SchemaChange.UpdateColumnNullability update, boolean disableNullToNotNull, DataField field, Integer depth) {
        DataType sourceRootType = SchemaManager.getRootType(field.type(), depth, update.fieldNames().length);
        SchemaManager.assertNullabilityChange(sourceRootType.isNullable(), update.newNullability(), StringUtils.join(Arrays.asList(update.fieldNames()), "."), disableNullToNotNull);
        sourceRootType = sourceRootType.copy(update.newNullability());
        return new DataField(field.id(), field.name(), SchemaManager.getArrayMapTypeWithTargetTypeRoot(field.type(), sourceRootType, depth, update.fieldNames().length), field.description(), field.defaultValue());
    }

    private static /* synthetic */ DataField lambda$generateTableSchema$5(SchemaChange.UpdateColumnType update, boolean disableNullToNotNull, boolean disableExplicitTypeCasting, DataField field, Integer depth) {
        DataType sourceRootType = SchemaManager.getRootType(field.type(), depth, update.fieldNames().length);
        DataType targetRootType = update.newDataType();
        if (update.keepNullability()) {
            targetRootType = targetRootType.copy(sourceRootType.isNullable());
        } else {
            SchemaManager.assertNullabilityChange(sourceRootType.isNullable(), targetRootType.isNullable(), StringUtils.join(Arrays.asList(update.fieldNames()), "."), disableNullToNotNull);
        }
        Preconditions.checkState(DataTypeCasts.supportsCast(sourceRootType, targetRootType, !disableExplicitTypeCasting) && CastExecutors.resolve(sourceRootType, targetRootType) != null, String.format("Column type %s[%s] cannot be converted to %s without loosing information.", field.name(), sourceRootType, targetRootType));
        return new DataField(field.id(), field.name(), SchemaManager.getArrayMapTypeWithTargetTypeRoot(field.type(), targetRootType, depth, update.fieldNames().length), field.description(), field.defaultValue());
    }

    private /* synthetic */ Identifier lambda$commitChanges$4() {
        return SchemaManager.identifierFromPath(this.tableRoot.toString(), true, this.branch);
    }

    private /* synthetic */ Catalog.TableNotExistException lambda$commitChanges$3() {
        return new Catalog.TableNotExistException(SchemaManager.identifierFromPath(this.tableRoot.toString(), true, this.branch));
    }

    private static /* synthetic */ Boolean lambda$commitChanges$2(SnapshotManager snapshotManager) {
        return snapshotManager.latestSnapshot() != null;
    }

    private static abstract class NestedColumnModifier {
        private final String[] updateFieldNames;
        private final LazyField<Identifier> identifier;

        private NestedColumnModifier(String[] updateFieldNames, LazyField<Identifier> identifier) {
            this.updateFieldNames = updateFieldNames;
            this.identifier = identifier;
        }

        private void updateIntermediateColumn(List<DataField> newFields, List<DataField> previousFields, int depth, int prevDepth) throws Catalog.ColumnNotExistException, Catalog.ColumnAlreadyExistException {
            if (depth == this.updateFieldNames.length - 1) {
                this.updateLastColumn(depth, newFields, this.updateFieldNames[depth]);
                return;
            }
            if (depth >= this.updateFieldNames.length) {
                this.updateLastColumn(prevDepth, previousFields, this.updateFieldNames[prevDepth]);
                return;
            }
            for (int i = 0; i < newFields.size(); ++i) {
                DataField field = newFields.get(i);
                if (!field.name().equals(this.updateFieldNames[depth])) continue;
                ArrayList<DataField> nestedFields = new ArrayList<DataField>();
                int newDepth = depth + this.extractRowDataFields(field.type(), nestedFields);
                this.updateIntermediateColumn(nestedFields, newFields, newDepth, depth);
                field = newFields.get(i);
                newFields.set(i, new DataField(field.id(), field.name(), this.wrapNewRowType(field.type(), nestedFields), field.description(), field.defaultValue()));
                return;
            }
            throw new Catalog.ColumnNotExistException(this.identifier.get(), String.join((CharSequence)".", Arrays.asList(this.updateFieldNames).subList(0, depth + 1)));
        }

        public void updateIntermediateColumn(List<DataField> newFields, int depth) throws Catalog.ColumnNotExistException, Catalog.ColumnAlreadyExistException {
            this.updateIntermediateColumn(newFields, newFields, depth, depth);
        }

        private int extractRowDataFields(DataType type, List<DataField> nestedFields) {
            switch (type.getTypeRoot()) {
                case ROW: {
                    nestedFields.addAll(((RowType)type).getFields());
                    return 1;
                }
                case ARRAY: {
                    return this.extractRowDataFields(((ArrayType)type).getElementType(), nestedFields) + 1;
                }
                case MAP: {
                    return this.extractRowDataFields(((MapType)type).getValueType(), nestedFields) + 1;
                }
            }
            return 1;
        }

        private DataType wrapNewRowType(DataType type, List<DataField> nestedFields) {
            switch (type.getTypeRoot()) {
                case ROW: {
                    return new RowType(type.isNullable(), nestedFields);
                }
                case ARRAY: {
                    return new ArrayType(type.isNullable(), this.wrapNewRowType(((ArrayType)type).getElementType(), nestedFields));
                }
                case MAP: {
                    MapType mapType = (MapType)type;
                    return new MapType(type.isNullable(), mapType.getKeyType(), this.wrapNewRowType(mapType.getValueType(), nestedFields));
                }
            }
            return type;
        }

        protected abstract void updateLastColumn(int var1, List<DataField> var2, String var3) throws Catalog.ColumnNotExistException, Catalog.ColumnAlreadyExistException;

        protected void assertColumnExists(List<DataField> newFields, String fieldName, LazyField<Identifier> lazyIdentifier) throws Catalog.ColumnNotExistException {
            for (DataField field : newFields) {
                if (!field.name().equals(fieldName)) continue;
                return;
            }
            throw new Catalog.ColumnNotExistException(lazyIdentifier.get(), this.getLastFieldName(fieldName));
        }

        protected void assertColumnNotExists(List<DataField> newFields, String fieldName, LazyField<Identifier> lazyIdentifier) throws Catalog.ColumnAlreadyExistException {
            for (DataField field : newFields) {
                if (!field.name().equals(fieldName)) continue;
                throw new Catalog.ColumnAlreadyExistException(lazyIdentifier.get(), this.getLastFieldName(fieldName));
            }
        }

        private String getLastFieldName(String fieldName) {
            ArrayList<String> fieldNames = new ArrayList<String>();
            int i = 0;
            while (i + 1 < this.updateFieldNames.length) {
                fieldNames.add(this.updateFieldNames[i]);
                ++i;
            }
            fieldNames.add(fieldName);
            return String.join((CharSequence)".", fieldNames);
        }
    }
}

