/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.io;

import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.paimon.annotation.VisibleForTesting;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.fileindex.FileIndexOptions;
import org.apache.paimon.format.FileFormat;
import org.apache.paimon.format.SimpleStatsCollector;
import org.apache.paimon.format.avro.AvroFileFormat;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.io.DataFileMeta;
import org.apache.paimon.io.DataFilePathFactory;
import org.apache.paimon.io.FileWriterContext;
import org.apache.paimon.io.RollingFileWriter;
import org.apache.paimon.io.RowDataFileWriter;
import org.apache.paimon.io.SimpleStatsProducer;
import org.apache.paimon.manifest.FileSource;
import org.apache.paimon.statistics.NoneSimpleColStatsCollector;
import org.apache.paimon.statistics.SimpleColStatsCollector;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.LongCounter;

public class RowDataRollingFileWriter
extends RollingFileWriter<InternalRow, DataFileMeta> {
    public RowDataRollingFileWriter(FileIO fileIO, long schemaId, FileFormat fileFormat, long targetFileSize, RowType writeSchema, DataFilePathFactory pathFactory, LongCounter seqNumCounter, String fileCompression, SimpleColStatsCollector.Factory[] statsCollectors, FileIndexOptions fileIndexOptions, FileSource fileSource, boolean asyncFileWrite, boolean statsDenseStore, @Nullable List<String> writeCols) {
        super(() -> new RowDataFileWriter(fileIO, RowDataRollingFileWriter.createFileWriterContext(fileFormat, writeSchema, statsCollectors, fileCompression), pathFactory.newPath(), writeSchema, schemaId, seqNumCounter, fileIndexOptions, fileSource, asyncFileWrite, statsDenseStore, pathFactory.isExternalPath(), writeCols), targetFileSize);
    }

    @VisibleForTesting
    static FileWriterContext createFileWriterContext(FileFormat fileFormat, RowType rowType, SimpleColStatsCollector.Factory[] statsCollectors, String fileCompression) {
        return new FileWriterContext(fileFormat.createWriterFactory(rowType), RowDataRollingFileWriter.createStatsProducer(fileFormat, rowType, statsCollectors), fileCompression);
    }

    private static SimpleStatsProducer createStatsProducer(FileFormat fileFormat, RowType rowType, SimpleColStatsCollector.Factory[] statsCollectors) {
        boolean isDisabled = Arrays.stream(SimpleColStatsCollector.create(statsCollectors)).allMatch(p -> p instanceof NoneSimpleColStatsCollector);
        if (isDisabled) {
            return SimpleStatsProducer.disabledProducer();
        }
        if (fileFormat instanceof AvroFileFormat) {
            SimpleStatsCollector collector = new SimpleStatsCollector(rowType, statsCollectors);
            return SimpleStatsProducer.fromCollector(collector);
        }
        return SimpleStatsProducer.fromExtractor(fileFormat.createStatsExtractor(rowType, statsCollectors).orElse(null));
    }
}

