/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.index;

import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.paimon.fs.Path;
import org.apache.paimon.index.IndexFileMeta;
import org.apache.paimon.index.IndexPathFactory;
import org.apache.paimon.io.DataFilePathFactory;

public class IndexInDataFileDirPathFactory
implements IndexPathFactory {
    private final String uuid;
    private final DataFilePathFactory dataFilePathFactory;
    private final AtomicInteger indexFileCount;

    public IndexInDataFileDirPathFactory(String uuid, AtomicInteger indexFileCount, DataFilePathFactory dataFilePathFactory) {
        this.uuid = uuid;
        this.dataFilePathFactory = dataFilePathFactory;
        this.indexFileCount = indexFileCount;
    }

    @Override
    public Path newPath() {
        String name = "index-" + this.uuid + "-" + this.indexFileCount.getAndIncrement();
        return this.dataFilePathFactory.newPathFromName(name);
    }

    @Override
    public Path toPath(IndexFileMeta file) {
        return Optional.ofNullable(file.externalPath()).map(Path::new).orElse(new Path(this.dataFilePathFactory.parent(), file.fileName()));
    }

    @Override
    public boolean isExternalPath() {
        return this.dataFilePathFactory.isExternalPath();
    }
}

