/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.data;

import java.util.ArrayList;
import org.apache.paimon.data.MultiSegments;
import org.apache.paimon.data.SingleSegments;
import org.apache.paimon.memory.MemorySegment;
import org.apache.paimon.utils.MathUtils;

public interface Segments {
    public long totalMemorySize();

    public static Segments create(ArrayList<MemorySegment> segments, int limitInLastSegment) {
        if (segments.size() == 1) {
            MemorySegment segment = segments.get(0);
            int roundUp = MathUtils.roundUpToPowerOf2(limitInLastSegment);
            if (roundUp < segment.size()) {
                MemorySegment newSegment = MemorySegment.allocateHeapMemory(roundUp);
                segment.copyTo(0, newSegment, 0, limitInLastSegment);
                segment = newSegment;
            }
            return new SingleSegments(segment, limitInLastSegment);
        }
        return new MultiSegments(segments, limitInLastSegment);
    }
}

