/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozone.rocksdiff;

import org.apache.hadoop.metrics2.MetricsCollector;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.MetricsSource;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.MetricsRegistry;
import org.apache.hadoop.metrics2.lib.MutableCounterLong;
import org.apache.hadoop.metrics2.lib.MutableGaugeLong;

@Metrics(about="SST File Pruning Metrics", context="ozone")
public final class SSTFilePruningMetrics
implements MetricsSource {
    private static final String METRICS_SOURCE_NAME_PREFIX = SSTFilePruningMetrics.class.getSimpleName();
    private final String metricSourceName;
    private final MetricsRegistry registry;
    @Metric(value={"Total no. of SST files pruned"})
    private MutableCounterLong filesPrunedTotal;
    @Metric(value={"No. of SST files pruned in the last batch"})
    private MutableGaugeLong filesPrunedLast;
    @Metric(value={"Total no. of SST files removed"})
    private MutableCounterLong filesSkippedTotal;
    @Metric(value={"Total no. of compactions processed"})
    private MutableCounterLong compactionsProcessed;
    @Metric(value={"No. of pending pruning jobs in queue"})
    private MutableGaugeLong pruneQueueSize;
    @Metric(value={"No. of pruning job failures"})
    private MutableCounterLong pruningFailures;

    private SSTFilePruningMetrics(String sourceName) {
        this.metricSourceName = sourceName;
        this.registry = new MetricsRegistry(this.metricSourceName);
    }

    public static SSTFilePruningMetrics create(String dbLocation) {
        String sourceName = METRICS_SOURCE_NAME_PREFIX + (dbLocation == null || dbLocation.isEmpty() ? "" : "-" + dbLocation.replaceAll("[/\\:\\s]", "_"));
        return (SSTFilePruningMetrics)DefaultMetricsSystem.instance().register(sourceName, "SST File Pruning Metrics", (Object)new SSTFilePruningMetrics(sourceName));
    }

    public void unRegister() {
        DefaultMetricsSystem.instance().unregisterSource(this.metricSourceName);
    }

    public void updateQueueSize(long queueSize) {
        this.pruneQueueSize.set(queueSize);
    }

    public void updateBatchLevelMetrics(long filesPruned, long filesSkipped, int compactions, long queueSize) {
        this.filesPrunedTotal.incr(filesPruned);
        this.filesPrunedLast.set(filesPruned);
        this.filesSkippedTotal.incr(filesSkipped);
        this.compactionsProcessed.incr((long)compactions);
        this.updateQueueSize(queueSize);
    }

    public void incrPruningFailures() {
        this.pruningFailures.incr();
    }

    public long getFilesPrunedTotal() {
        return this.filesPrunedTotal.value();
    }

    public long getFilesPrunedLast() {
        return this.filesPrunedLast.value();
    }

    public long getFilesRemovedTotal() {
        return this.filesSkippedTotal.value();
    }

    public long getCompactionsProcessed() {
        return this.compactionsProcessed.value();
    }

    public long getPruneQueueSize() {
        return this.pruneQueueSize.value();
    }

    public long getPruningFailures() {
        return this.pruningFailures.value();
    }

    public void getMetrics(MetricsCollector collector, boolean all) {
        MetricsRecordBuilder recordBuilder = collector.addRecord(this.metricSourceName);
        this.filesPrunedTotal.snapshot(recordBuilder, all);
        this.filesPrunedLast.snapshot(recordBuilder, all);
        this.filesSkippedTotal.snapshot(recordBuilder, all);
        this.compactionsProcessed.snapshot(recordBuilder, all);
        this.pruneQueueSize.snapshot(recordBuilder, all);
        this.pruningFailures.snapshot(recordBuilder, all);
    }
}

