/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozone.rocksdiff;

import com.google.common.graph.GraphBuilder;
import com.google.common.graph.MutableGraph;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.ozone.compaction.log.CompactionFileInfo;
import org.apache.ozone.rocksdiff.CompactionNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompactionDag {
    private static final Logger LOG = LoggerFactory.getLogger(CompactionDag.class);
    private final ConcurrentMap<String, CompactionNode> compactionNodeMap = new ConcurrentHashMap<String, CompactionNode>();
    private final MutableGraph<CompactionNode> forwardCompactionDAG = GraphBuilder.directed().build();
    private final MutableGraph<CompactionNode> backwardCompactionDAG = GraphBuilder.directed().build();

    private CompactionNode addNodeToDAG(String file, long seqNum, String startKey, String endKey, String columnFamily) {
        CompactionNode fileNode = new CompactionNode(file, seqNum, startKey, endKey, columnFamily);
        this.backwardCompactionDAG.addNode((Object)fileNode);
        this.forwardCompactionDAG.addNode((Object)fileNode);
        return fileNode;
    }

    public void populateCompactionDAG(List<CompactionFileInfo> inputFiles, List<CompactionFileInfo> outputFiles, long seqNum) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Input files: {} -> Output files: {}", inputFiles, outputFiles);
        }
        for (CompactionFileInfo outfile : outputFiles) {
            CompactionNode outfileNode = this.compactionNodeMap.computeIfAbsent(outfile.getFileName(), file -> this.addNodeToDAG((String)file, seqNum, outfile.getStartKey(), outfile.getEndKey(), outfile.getColumnFamily()));
            for (CompactionFileInfo infile : inputFiles) {
                CompactionNode infileNode = this.compactionNodeMap.computeIfAbsent(infile.getFileName(), file -> this.addNodeToDAG((String)file, seqNum, infile.getStartKey(), infile.getEndKey(), infile.getColumnFamily()));
                if (Objects.equals(outfileNode.getFileName(), infileNode.getFileName())) continue;
                this.forwardCompactionDAG.putEdge((Object)outfileNode, (Object)infileNode);
                this.backwardCompactionDAG.putEdge((Object)infileNode, (Object)outfileNode);
            }
        }
    }

    public Set<String> pruneNodesFromDag(Set<CompactionNode> nodesToRemove) {
        this.pruneBackwardDag(this.backwardCompactionDAG, nodesToRemove);
        Set<String> sstFilesPruned = this.pruneForwardDag(this.forwardCompactionDAG, nodesToRemove);
        nodesToRemove.forEach(this.compactionNodeMap::remove);
        return sstFilesPruned;
    }

    Set<String> pruneBackwardDag(MutableGraph<CompactionNode> backwardDag, Set<CompactionNode> startNodes) {
        HashSet<String> removedFiles = new HashSet<String>();
        Set<CompactionNode> currentLevel = startNodes;
        while (!currentLevel.isEmpty()) {
            HashSet<CompactionNode> nextLevel = new HashSet<CompactionNode>();
            for (CompactionNode current : currentLevel) {
                if (!backwardDag.nodes().contains(current)) continue;
                nextLevel.addAll(backwardDag.predecessors((Object)current));
                backwardDag.removeNode((Object)current);
                removedFiles.add(current.getFileName());
            }
            currentLevel = nextLevel;
        }
        return removedFiles;
    }

    Set<String> pruneForwardDag(MutableGraph<CompactionNode> forwardDag, Set<CompactionNode> startNodes) {
        HashSet<String> removedFiles = new HashSet<String>();
        HashSet<CompactionNode> currentLevel = new HashSet<CompactionNode>(startNodes);
        while (!currentLevel.isEmpty()) {
            HashSet nextLevel = new HashSet();
            for (CompactionNode current : currentLevel) {
                if (!forwardDag.nodes().contains(current)) continue;
                nextLevel.addAll(forwardDag.successors((Object)current));
                forwardDag.removeNode((Object)current);
                removedFiles.add(current.getFileName());
            }
            currentLevel = nextLevel;
        }
        return removedFiles;
    }

    public MutableGraph<CompactionNode> getForwardCompactionDAG() {
        return this.forwardCompactionDAG;
    }

    public MutableGraph<CompactionNode> getBackwardCompactionDAG() {
        return this.backwardCompactionDAG;
    }

    public ConcurrentMap<String, CompactionNode> getCompactionMap() {
        return this.compactionNodeMap;
    }

    public CompactionNode getCompactionNode(String fileName) {
        return (CompactionNode)this.compactionNodeMap.get(fileName);
    }
}

