/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.repair;

import jakarta.annotation.Nullable;
import java.nio.charset.StandardCharsets;
import java.util.Scanner;
import java.util.concurrent.Callable;
import org.apache.hadoop.hdds.cli.AbstractSubcommand;
import picocli.CommandLine;

@CommandLine.Command
public abstract class RepairTool
extends AbstractSubcommand
implements Callable<Void> {
    private static final String WARNING_SYS_USER_MESSAGE = "ATTENTION: Running as user %s. Make sure this is the same user used to run the Ozone process. Are you sure you want to continue (y/N)? ";
    @CommandLine.Option(names={"--force"}, description={"Use this flag if you want to bypass the check in false-positive cases."})
    private boolean force;
    @CommandLine.Option(names={"--dry-run"}, defaultValue="false", fallbackValue="true", description={"Simulate repair, but do not make any changes"})
    private boolean dryRun;

    protected abstract void execute() throws Exception;

    @Nullable
    protected Component serviceToBeOffline() {
        return null;
    }

    @Override
    public final Void call() throws Exception {
        if (!this.dryRun) {
            this.confirmUser();
        }
        if (this.isServiceStateOK()) {
            this.execute();
        }
        return null;
    }

    private boolean isServiceStateOK() {
        Component service = this.serviceToBeOffline();
        if (service == null) {
            return true;
        }
        if (!RepairTool.isServiceRunning(service)) {
            this.info("No running %s service detected. Proceeding with repair.", new Object[]{service});
            return true;
        }
        String servicePid = RepairTool.getServicePid(service);
        if (this.force) {
            this.info("Warning: --force flag used. Proceeding despite %s being detected as running with PID %s.", new Object[]{service, servicePid});
            return true;
        }
        this.error("Error: %s is currently running on this host with PID %s. Stop the service before running the repair tool.", new Object[]{service, servicePid});
        return false;
    }

    private static String getServicePid(Component service) {
        return System.getenv(String.format("OZONE_%s_PID", new Object[]{service}));
    }

    private static boolean isServiceRunning(Component service) {
        return "true".equals(System.getenv(String.format("OZONE_%s_RUNNING", new Object[]{service})));
    }

    protected boolean isDryRun() {
        return this.dryRun;
    }

    protected void info(String msg, Object ... args) {
        this.out().println(this.formatMessage(msg, args));
    }

    protected void error(String msg, Object ... args) {
        this.err().println(this.formatMessage(msg, args));
    }

    private String formatMessage(String msg, Object[] args) {
        if (args != null && args.length > 0) {
            msg = String.format(msg, args);
        }
        if (this.isDryRun()) {
            msg = "[dry run] " + msg;
        }
        return msg;
    }

    protected void confirmUser() {
        String currentUser = this.getSystemUserName();
        boolean confirmed = "y".equalsIgnoreCase(this.getConsoleReadLineWithFormat(currentUser));
        if (!confirmed) {
            throw new IllegalStateException("Aborting command.");
        }
        this.info("Run as user: " + currentUser, new Object[0]);
    }

    private String getSystemUserName() {
        return System.getProperty("user.name");
    }

    private String getConsoleReadLineWithFormat(String currentUser) {
        this.err().printf(WARNING_SYS_USER_MESSAGE, currentUser);
        return new Scanner(System.in, StandardCharsets.UTF_8.name()).nextLine().trim();
    }

    public static enum Component {
        DATANODE,
        OM,
        SCM;

    }
}

