/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.freon;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.EnvironmentVariableCredentialsProvider;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import org.apache.hadoop.ozone.freon.BaseFreonGenerator;
import picocli.CommandLine;

public class S3EntityGenerator
extends BaseFreonGenerator {
    @CommandLine.Option(names={"-e", "--endpoint"}, description={"S3 HTTP endpoint"}, defaultValue="http://localhost:9878")
    private String endpoint;
    private AmazonS3 s3;

    protected void s3ClientInit() {
        this.init();
        AmazonS3ClientBuilder amazonS3ClientBuilder = (AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withCredentials((AWSCredentialsProvider)new EnvironmentVariableCredentialsProvider());
        if (!this.endpoint.isEmpty()) {
            ((AmazonS3ClientBuilder)amazonS3ClientBuilder.withPathStyleAccessEnabled(Boolean.valueOf(true))).withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(this.endpoint, "us-east-1"));
        } else {
            amazonS3ClientBuilder.withRegion(Regions.DEFAULT_REGION);
        }
        this.s3 = (AmazonS3)amazonS3ClientBuilder.build();
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public AmazonS3 getS3() {
        return this.s3;
    }
}

