/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.debug;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.hdds.utils.db.Codec;
import org.apache.hadoop.hdds.utils.db.RocksDatabase;
import org.apache.hadoop.hdds.utils.db.StringCodec;
import org.apache.hadoop.hdds.utils.db.managed.ManagedRocksDB;
import org.rocksdb.ColumnFamilyDescriptor;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;

public final class RocksDBUtils {
    private RocksDBUtils() {
    }

    public static List<ColumnFamilyDescriptor> getColumnFamilyDescriptors(String dbPath) throws RocksDBException {
        ArrayList<ColumnFamilyDescriptor> cfs = new ArrayList<ColumnFamilyDescriptor>();
        List cfList = RocksDatabase.listColumnFamiliesEmptyOptions((String)dbPath);
        if (cfList != null) {
            for (byte[] b : cfList) {
                cfs.add(new ColumnFamilyDescriptor(b));
            }
        }
        return cfs;
    }

    public static ColumnFamilyHandle getColumnFamilyHandle(String columnFamilyName, List<ColumnFamilyHandle> cfHandleList) throws RocksDBException {
        byte[] nameBytes = columnFamilyName.getBytes(StandardCharsets.UTF_8);
        for (ColumnFamilyHandle cf : cfHandleList) {
            if (!Arrays.equals(cf.getName(), nameBytes)) continue;
            return cf;
        }
        return null;
    }

    public static <T> T getValue(ManagedRocksDB db, ColumnFamilyHandle columnFamilyHandle, String key, Codec<T> codec) throws IOException, RocksDBException {
        byte[] bytes = ((RocksDB)db.get()).get(columnFamilyHandle, StringCodec.get().toPersistedFormat(key));
        return (T)(bytes != null ? codec.fromPersistedFormat(bytes) : null);
    }
}

