/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.safemode;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.scm.container.ContainerManager;
import org.apache.hadoop.hdds.scm.ha.SCMContext;
import org.apache.hadoop.hdds.scm.node.NodeManager;
import org.apache.hadoop.hdds.scm.pipeline.PipelineManager;
import org.apache.hadoop.hdds.scm.safemode.DataNodeSafeModeRule;
import org.apache.hadoop.hdds.scm.safemode.ECContainerSafeModeRule;
import org.apache.hadoop.hdds.scm.safemode.HealthyPipelineSafeModeRule;
import org.apache.hadoop.hdds.scm.safemode.OneReplicaPipelineSafeModeRule;
import org.apache.hadoop.hdds.scm.safemode.RatisContainerSafeModeRule;
import org.apache.hadoop.hdds.scm.safemode.SCMSafeModeManager;
import org.apache.hadoop.hdds.scm.safemode.SafeModeExitRule;
import org.apache.hadoop.hdds.server.events.EventQueue;

public final class SafeModeRuleFactory {
    private final ConfigurationSource config;
    private final SCMContext scmContext;
    private final EventQueue eventQueue;
    private final PipelineManager pipelineManager;
    private final ContainerManager containerManager;
    private final NodeManager nodeManager;
    private final List<SafeModeExitRule<?>> safeModeRules;
    private final List<SafeModeExitRule<?>> preCheckRules;
    private static SafeModeRuleFactory instance;

    private SafeModeRuleFactory(ConfigurationSource config, SCMContext scmContext, EventQueue eventQueue, PipelineManager pipelineManager, ContainerManager containerManager, NodeManager nodeManager) {
        this.config = config;
        this.scmContext = scmContext;
        this.eventQueue = eventQueue;
        this.pipelineManager = pipelineManager;
        this.containerManager = containerManager;
        this.nodeManager = nodeManager;
        this.safeModeRules = new ArrayList();
        this.preCheckRules = new ArrayList();
    }

    public void addSafeModeManager(SCMSafeModeManager safeModeManager) {
        this.loadRules(safeModeManager);
    }

    private void loadRules(SCMSafeModeManager safeModeManager) {
        RatisContainerSafeModeRule ratisContainerRule = new RatisContainerSafeModeRule(this.eventQueue, this.config, this.containerManager, safeModeManager);
        ECContainerSafeModeRule ecContainerRule = new ECContainerSafeModeRule(this.eventQueue, this.config, this.containerManager, safeModeManager);
        DataNodeSafeModeRule datanodeRule = new DataNodeSafeModeRule(this.eventQueue, this.config, this.nodeManager, safeModeManager);
        this.safeModeRules.add(ratisContainerRule);
        this.safeModeRules.add(ecContainerRule);
        this.safeModeRules.add(datanodeRule);
        this.preCheckRules.add(datanodeRule);
        if (this.pipelineManager != null) {
            this.safeModeRules.add(new HealthyPipelineSafeModeRule(this.eventQueue, this.pipelineManager, safeModeManager, this.config, this.scmContext, this.nodeManager));
            this.safeModeRules.add(new OneReplicaPipelineSafeModeRule(this.eventQueue, this.pipelineManager, safeModeManager, this.config));
        }
    }

    public static synchronized SafeModeRuleFactory getInstance() {
        if (instance != null) {
            return instance;
        }
        throw new IllegalStateException("SafeModeRuleFactory not initialized, call initialize method before getInstance.");
    }

    public static synchronized void initialize(ConfigurationSource config, SCMContext scmContext, EventQueue eventQueue, PipelineManager pipelineManager, ContainerManager containerManager, NodeManager nodeManager) {
        instance = new SafeModeRuleFactory(config, scmContext, eventQueue, pipelineManager, containerManager, nodeManager);
    }

    public List<SafeModeExitRule<?>> getSafeModeRules() {
        return this.safeModeRules;
    }

    public List<SafeModeExitRule<?>> getPreCheckRules() {
        return this.preCheckRules;
    }

    public <T extends SafeModeExitRule<?>> T getSafeModeRule(Class<T> ruleClass) {
        return (T)((SafeModeExitRule)this.safeModeRules.stream().filter(r -> ruleClass.isAssignableFrom(r.getClass())).map(ruleClass::cast).findFirst().orElse(null));
    }
}

