/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.node;

import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;

public final class NodeStatus {
    private static final Map<HddsProtos.NodeOperationalState, Map<HddsProtos.NodeState, NodeStatus>> CONSTANTS;
    private static final Set<HddsProtos.NodeOperationalState> OUT_OF_SERVICE_STATES;
    private static final NodeStatus IN_SERVICE_HEALTHY;
    private static final NodeStatus IN_SERVICE_HEALTHY_READONLY;
    private static final Set<HddsProtos.NodeOperationalState> MAINTENANCE_STATES;
    private static final Set<HddsProtos.NodeOperationalState> DECOMMISSION_STATES;
    private static final NodeStatus IN_SERVICE_STALE;
    private static final NodeStatus IN_SERVICE_DEAD;
    private final HddsProtos.NodeState health;
    private final HddsProtos.NodeOperationalState operationalState;
    private final long opStateExpiryEpochSeconds;

    public static NodeStatus valueOf(HddsProtos.NodeOperationalState op, HddsProtos.NodeState health) {
        return NodeStatus.valueOf(op, health, 0L);
    }

    public static NodeStatus valueOf(HddsProtos.NodeOperationalState op, HddsProtos.NodeState health, long opExpiryEpochSeconds) {
        Objects.requireNonNull(op, "op == null");
        Objects.requireNonNull(health, "health == null");
        return opExpiryEpochSeconds == 0L ? CONSTANTS.get(op).get(health) : new NodeStatus(health, op, opExpiryEpochSeconds);
    }

    public static Set<HddsProtos.NodeOperationalState> maintenanceStates() {
        return MAINTENANCE_STATES;
    }

    public static Set<HddsProtos.NodeOperationalState> decommissionStates() {
        return DECOMMISSION_STATES;
    }

    public static Set<HddsProtos.NodeOperationalState> outOfServiceStates() {
        return OUT_OF_SERVICE_STATES;
    }

    public static NodeStatus inServiceHealthy() {
        return IN_SERVICE_HEALTHY;
    }

    public static NodeStatus inServiceHealthyReadOnly() {
        return IN_SERVICE_HEALTHY_READONLY;
    }

    public static NodeStatus inServiceStale() {
        return IN_SERVICE_STALE;
    }

    public static NodeStatus inServiceDead() {
        return IN_SERVICE_DEAD;
    }

    private NodeStatus(HddsProtos.NodeState health, HddsProtos.NodeOperationalState op, long opExpiryEpochSeconds) {
        this.health = health;
        this.operationalState = op;
        this.opStateExpiryEpochSeconds = opExpiryEpochSeconds;
    }

    public NodeStatus newNodeState(HddsProtos.NodeState newHealth) {
        return NodeStatus.valueOf(this.operationalState, newHealth, this.opStateExpiryEpochSeconds);
    }

    public NodeStatus newOperationalState(HddsProtos.NodeOperationalState op, long opExpiryEpochSeconds) {
        return NodeStatus.valueOf(op, this.health, opExpiryEpochSeconds);
    }

    public boolean isNodeWritable() {
        return this.health == HddsProtos.NodeState.HEALTHY && this.operationalState == HddsProtos.NodeOperationalState.IN_SERVICE;
    }

    public HddsProtos.NodeState getHealth() {
        return this.health;
    }

    public HddsProtos.NodeOperationalState getOperationalState() {
        return this.operationalState;
    }

    public long getOpStateExpiryEpochSeconds() {
        return this.opStateExpiryEpochSeconds;
    }

    public boolean operationalStateExpired() {
        return this.opStateExpiryEpochSeconds != 0L && System.currentTimeMillis() >= 1000L * this.opStateExpiryEpochSeconds;
    }

    public boolean isInService() {
        return this.operationalState == HddsProtos.NodeOperationalState.IN_SERVICE;
    }

    public boolean isDecommission() {
        return DECOMMISSION_STATES.contains(this.operationalState);
    }

    public boolean isDecommissioning() {
        return this.operationalState == HddsProtos.NodeOperationalState.DECOMMISSIONING;
    }

    public boolean isDecommissioned() {
        return this.operationalState == HddsProtos.NodeOperationalState.DECOMMISSIONED;
    }

    public boolean isMaintenance() {
        return NodeStatus.maintenanceStates().contains(this.operationalState);
    }

    public boolean isEnteringMaintenance() {
        return this.operationalState == HddsProtos.NodeOperationalState.ENTERING_MAINTENANCE;
    }

    public boolean isInMaintenance() {
        return this.operationalState == HddsProtos.NodeOperationalState.IN_MAINTENANCE;
    }

    public boolean isHealthy() {
        return this.health == HddsProtos.NodeState.HEALTHY || this.health == HddsProtos.NodeState.HEALTHY_READONLY;
    }

    public boolean isAlive() {
        return this.health == HddsProtos.NodeState.HEALTHY || this.health == HddsProtos.NodeState.STALE;
    }

    public boolean isDead() {
        return this.health == HddsProtos.NodeState.DEAD;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NodeStatus that = (NodeStatus)obj;
        return this.operationalState == that.operationalState && this.health == that.health && this.opStateExpiryEpochSeconds == that.opStateExpiryEpochSeconds;
    }

    public int hashCode() {
        return Objects.hash(this.health, this.operationalState, this.opStateExpiryEpochSeconds);
    }

    public String toString() {
        String expiry = this.opStateExpiryEpochSeconds == 0L ? "no expiry" : "expiry: " + this.opStateExpiryEpochSeconds + "s";
        return this.operationalState + "(" + expiry + ")-" + this.health;
    }

    static {
        EnumMap map = new EnumMap(HddsProtos.NodeOperationalState.class);
        for (HddsProtos.NodeOperationalState op : HddsProtos.NodeOperationalState.values()) {
            EnumMap<HddsProtos.NodeState, NodeStatus> healthMap = new EnumMap<HddsProtos.NodeState, NodeStatus>(HddsProtos.NodeState.class);
            for (HddsProtos.NodeState health : HddsProtos.NodeState.values()) {
                healthMap.put(health, new NodeStatus(health, op, 0L));
            }
            map.put(op, Collections.unmodifiableMap(healthMap));
        }
        CONSTANTS = Collections.unmodifiableMap(map);
        OUT_OF_SERVICE_STATES = Collections.unmodifiableSet(EnumSet.of(HddsProtos.NodeOperationalState.DECOMMISSIONING, HddsProtos.NodeOperationalState.DECOMMISSIONED, HddsProtos.NodeOperationalState.ENTERING_MAINTENANCE, HddsProtos.NodeOperationalState.IN_MAINTENANCE));
        IN_SERVICE_HEALTHY = NodeStatus.valueOf(HddsProtos.NodeOperationalState.IN_SERVICE, HddsProtos.NodeState.HEALTHY);
        IN_SERVICE_HEALTHY_READONLY = NodeStatus.valueOf(HddsProtos.NodeOperationalState.IN_SERVICE, HddsProtos.NodeState.HEALTHY_READONLY);
        MAINTENANCE_STATES = Collections.unmodifiableSet(EnumSet.of(HddsProtos.NodeOperationalState.ENTERING_MAINTENANCE, HddsProtos.NodeOperationalState.IN_MAINTENANCE));
        DECOMMISSION_STATES = Collections.unmodifiableSet(EnumSet.of(HddsProtos.NodeOperationalState.DECOMMISSIONING, HddsProtos.NodeOperationalState.DECOMMISSIONED));
        IN_SERVICE_STALE = NodeStatus.valueOf(HddsProtos.NodeOperationalState.IN_SERVICE, HddsProtos.NodeState.STALE);
        IN_SERVICE_DEAD = NodeStatus.valueOf(HddsProtos.NodeOperationalState.IN_SERVICE, HddsProtos.NodeState.DEAD);
    }
}

