/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.node;

import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.scm.ha.SCMService;
import org.apache.hadoop.hdds.scm.ha.SCMServiceManager;
import org.apache.hadoop.hdds.scm.node.NodeDecommissionManager;
import org.apache.hadoop.hdds.scm.node.states.NodeNotFoundException;
import org.apache.hadoop.hdds.scm.pipeline.PipelineManager;
import org.apache.hadoop.hdds.server.events.EventHandler;
import org.apache.hadoop.hdds.server.events.EventPublisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeAddressUpdateHandler
implements EventHandler<DatanodeDetails> {
    private static final Logger LOG = LoggerFactory.getLogger(NodeAddressUpdateHandler.class);
    private final PipelineManager pipelineManager;
    private final NodeDecommissionManager decommissionManager;
    private final SCMServiceManager serviceManager;

    public NodeAddressUpdateHandler(PipelineManager pipelineManager, NodeDecommissionManager decommissionManager, SCMServiceManager serviceManager) {
        this.pipelineManager = pipelineManager;
        this.decommissionManager = decommissionManager;
        this.serviceManager = serviceManager;
    }

    public void onMessage(DatanodeDetails datanodeDetails, EventPublisher publisher) {
        try {
            LOG.info("Closing stale pipelines for datanode: {}", (Object)datanodeDetails);
            this.pipelineManager.closeStalePipelines(datanodeDetails);
            this.serviceManager.notifyEventTriggered(SCMService.Event.NODE_ADDRESS_UPDATE_HANDLER_TRIGGERED);
            this.decommissionManager.continueAdminForNode(datanodeDetails);
        }
        catch (NodeNotFoundException e) {
            LOG.error("NodeNotFound when updating the node Ip or host name to the decommissionManager", (Throwable)e);
        }
    }
}

