/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.metadata;

import jakarta.annotation.Nonnull;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import org.apache.hadoop.hdds.security.x509.certificate.utils.CertificateCodec;
import org.apache.hadoop.hdds.utils.IOUtils;
import org.apache.hadoop.hdds.utils.db.Codec;
import org.apache.hadoop.hdds.utils.db.CodecBuffer;
import org.apache.hadoop.hdds.utils.db.CodecException;
import org.apache.hadoop.hdds.utils.io.LengthOutputStream;
import org.apache.ratis.util.function.CheckedFunction;

public final class X509CertificateCodec
implements Codec<X509Certificate> {
    private static final int INITIAL_CAPACITY = 4096;
    private static final Codec<X509Certificate> INSTANCE = new X509CertificateCodec();

    public static Codec<X509Certificate> get() {
        return INSTANCE;
    }

    private X509CertificateCodec() {
    }

    public Class<X509Certificate> getTypeClass() {
        return X509Certificate.class;
    }

    public boolean supportCodecBuffer() {
        return true;
    }

    private CheckedFunction<OutputStream, Integer, IOException> writeTo(final X509Certificate object) {
        return new CheckedFunction<OutputStream, Integer, IOException>(){

            public Integer apply(OutputStream out) throws IOException {
                return ((LengthOutputStream)CertificateCodec.writePEMEncoded((X509Certificate)object, (OutputStream)new LengthOutputStream(out))).getLength();
            }

            public String toString() {
                return "cert: " + object;
            }
        };
    }

    public CodecBuffer toCodecBuffer(@Nonnull X509Certificate object, CodecBuffer.Allocator allocator) throws CodecException {
        return ((CodecBuffer)allocator.apply(-4096)).put(this.writeTo(object));
    }

    public X509Certificate fromCodecBuffer(@Nonnull CodecBuffer buffer) throws CodecException {
        X509Certificate x509Certificate;
        InputStream in = buffer.getInputStream();
        try {
            x509Certificate = CertificateCodec.readX509Certificate((InputStream)in);
        }
        catch (CertificateException e) {
            try {
                throw new CodecException("Failed to readX509Certificate from " + buffer, (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly((AutoCloseable[])new AutoCloseable[]{in});
                throw throwable;
            }
        }
        IOUtils.closeQuietly((AutoCloseable[])new AutoCloseable[]{in});
        return x509Certificate;
    }

    public byte[] toPersistedFormat(X509Certificate object) throws CodecException {
        try (CodecBuffer buffer = this.toHeapCodecBuffer(object);){
            byte[] byArray = buffer.getArray();
            return byArray;
        }
    }

    public X509Certificate fromPersistedFormat(byte[] rawData) throws CodecException {
        ByteArrayInputStream in = new ByteArrayInputStream(rawData);
        try {
            return CertificateCodec.readX509Certificate((InputStream)in);
        }
        catch (CertificateException e) {
            throw new CodecException("Failed to readX509Certificate from rawData, length=" + rawData.length, (Throwable)e);
        }
    }

    public X509Certificate copyObject(X509Certificate object) {
        return object;
    }
}

