/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.ha;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hdds.scm.ha.SCMService;
import org.apache.hadoop.hdds.scm.ha.SCMServiceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SCMServiceManager {
    private static final Logger LOG = LoggerFactory.getLogger(SCMServiceManager.class);
    private final List<SCMService> services = new ArrayList<SCMService>();

    public synchronized void register(SCMService service) {
        Preconditions.checkNotNull((Object)service);
        LOG.info("Registering service {}.", (Object)service.getServiceName());
        this.services.add(service);
    }

    public synchronized void notifyStatusChanged() {
        for (SCMService service : this.services) {
            LOG.debug("Notify service:{}.", (Object)service.getServiceName());
            service.notifyStatusChanged();
        }
    }

    public synchronized void notifyEventTriggered(SCMService.Event event) {
        for (SCMService service : this.services) {
            LOG.debug("Notify service:{} with event:{}.", (Object)service.getServiceName(), (Object)event);
            service.notifyEventTriggered(event);
        }
    }

    public synchronized void start() {
        for (SCMService service : this.services) {
            LOG.debug("Starting service:{}.", (Object)service.getServiceName());
            try {
                service.start();
            }
            catch (SCMServiceException e) {
                LOG.warn("Could not start " + service.getServiceName(), (Throwable)e);
            }
        }
    }

    public synchronized void stop() {
        for (SCMService service : this.services) {
            LOG.debug("Stopping service:{}.", (Object)service.getServiceName());
            service.stop();
        }
    }
}

