/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.ha;

import java.net.InetSocketAddress;
import org.apache.hadoop.hdds.NodeDetails;
import org.apache.hadoop.net.NetUtils;

public final class SCMNodeDetails
extends NodeDetails {
    private final InetSocketAddress blockProtocolServerAddress;
    private final String blockProtocolServerAddressKey;
    private final InetSocketAddress clientProtocolServerAddress;
    private final String clientProtocolServerAddressKey;
    private final InetSocketAddress datanodeProtocolServerAddress;
    private final String datanodeAddressKey;
    private final int grpcPort;

    private SCMNodeDetails(Builder b) {
        super(b.scmServiceId, b.scmNodeId, b.rpcAddress, b.ratisPort, b.httpAddr, b.httpsAddr);
        this.grpcPort = b.grpcPort;
        this.blockProtocolServerAddress = b.blockProtocolServerAddress;
        this.clientProtocolServerAddress = b.clientProtocolServerAddress;
        this.datanodeProtocolServerAddress = b.datanodeProtocolServerAddress;
        this.datanodeAddressKey = b.datanodeAddressKey;
        this.blockProtocolServerAddressKey = b.blockProtocolServerAddressKey;
        this.clientProtocolServerAddressKey = b.clientProtocolServerAddressKey;
    }

    public String toString() {
        return "SCMNodeDetails[scmServiceId=" + this.getServiceId() + ", scmNodeId=" + this.getNodeId() + ", rpcAddress=" + this.getRpcAddressString() + ", ratisPort=" + this.getRatisPort() + ", httpAddress=" + this.getHttpAddress() + ", httpsAddress=" + this.getHttpsAddress() + ", blockProtocolServerAddress=" + this.getBlockProtocolServerAddress() + ", clientProtocolServerAddress=" + this.getClientProtocolServerAddress() + ", datanodeProtocolServerAddress=" + this.getDatanodeProtocolServerAddress() + "]";
    }

    public String getRpcAddressString() {
        return NetUtils.getHostPortString((InetSocketAddress)this.getRpcAddress());
    }

    public InetSocketAddress getClientProtocolServerAddress() {
        return this.clientProtocolServerAddress;
    }

    public String getClientProtocolServerAddressKey() {
        return this.clientProtocolServerAddressKey;
    }

    public InetSocketAddress getBlockProtocolServerAddress() {
        return this.blockProtocolServerAddress;
    }

    public String getBlockProtocolServerAddressKey() {
        return this.blockProtocolServerAddressKey;
    }

    public InetSocketAddress getDatanodeProtocolServerAddress() {
        return this.datanodeProtocolServerAddress;
    }

    public String getDatanodeAddressKey() {
        return this.datanodeAddressKey;
    }

    public int getGrpcPort() {
        return this.grpcPort;
    }

    public static class Builder {
        private String scmServiceId;
        private String scmNodeId;
        private InetSocketAddress rpcAddress;
        private int ratisPort;
        private int grpcPort;
        private String httpAddr;
        private String httpsAddr;
        private InetSocketAddress blockProtocolServerAddress;
        private String blockProtocolServerAddressKey;
        private InetSocketAddress clientProtocolServerAddress;
        private String clientProtocolServerAddressKey;
        private InetSocketAddress datanodeProtocolServerAddress;
        private String datanodeAddressKey;

        public Builder setDatanodeAddressKey(String addressKey) {
            this.datanodeAddressKey = addressKey;
            return this;
        }

        public Builder setBlockProtocolServerAddressKey(String addressKey) {
            this.blockProtocolServerAddressKey = addressKey;
            return this;
        }

        public Builder setBlockProtocolServerAddress(InetSocketAddress address) {
            this.blockProtocolServerAddress = address;
            return this;
        }

        public Builder setClientProtocolServerAddress(InetSocketAddress address) {
            this.clientProtocolServerAddress = address;
            return this;
        }

        public Builder setClientProtocolServerAddressKey(String addressKey) {
            this.clientProtocolServerAddressKey = addressKey;
            return this;
        }

        public Builder setDatanodeProtocolServerAddress(InetSocketAddress address) {
            this.datanodeProtocolServerAddress = address;
            return this;
        }

        public Builder setRpcAddress(InetSocketAddress rpcAddr) {
            this.rpcAddress = rpcAddr;
            return this;
        }

        public Builder setRatisPort(int port) {
            this.ratisPort = port;
            return this;
        }

        public Builder setGrpcPort(int port) {
            this.grpcPort = port;
            return this;
        }

        public Builder setSCMServiceId(String serviceId) {
            this.scmServiceId = serviceId;
            return this;
        }

        public Builder setSCMNodeId(String nodeId) {
            this.scmNodeId = nodeId;
            return this;
        }

        public Builder setHttpAddress(String httpAddress) {
            this.httpAddr = httpAddress;
            return this;
        }

        public Builder setHttpsAddress(String httpsAddress) {
            this.httpsAddr = httpsAddress;
            return this;
        }

        public SCMNodeDetails build() {
            return new SCMNodeDetails(this);
        }
    }
}

