/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.container.replication;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.hdds.protocol.DatanodeID;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.hdds.scm.container.ContainerReplica;

public class QuasiClosedStuckReplicaCount {
    private final Map<DatanodeID, Set<ContainerReplica>> replicasByOrigin = new HashMap<DatanodeID, Set<ContainerReplica>>();
    private final Map<DatanodeID, Set<ContainerReplica>> inServiceReplicasByOrigin = new HashMap<DatanodeID, Set<ContainerReplica>>();
    private final Map<DatanodeID, Set<ContainerReplica>> maintenanceReplicasByOrigin = new HashMap<DatanodeID, Set<ContainerReplica>>();
    private final int minHealthyForMaintenance;
    private final boolean hasHealthyReplicas;
    private final boolean hasOutOfServiceReplicas;

    public QuasiClosedStuckReplicaCount(Set<ContainerReplica> replicas, int minHealthyForMaintenance) {
        this.minHealthyForMaintenance = minHealthyForMaintenance;
        boolean hasHealthy = false;
        boolean hasOutOfService = false;
        for (ContainerReplica r : replicas) {
            if (r.getState() != StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State.UNHEALTHY) {
                hasHealthy = true;
            }
            this.replicasByOrigin.computeIfAbsent(r.getOriginDatanodeId(), k -> new HashSet()).add(r);
            HddsProtos.NodeOperationalState opState = r.getDatanodeDetails().getPersistedOpState();
            if (opState == HddsProtos.NodeOperationalState.IN_SERVICE) {
                this.inServiceReplicasByOrigin.computeIfAbsent(r.getOriginDatanodeId(), k -> new HashSet()).add(r);
                continue;
            }
            if (opState == HddsProtos.NodeOperationalState.IN_MAINTENANCE || opState == HddsProtos.NodeOperationalState.ENTERING_MAINTENANCE) {
                this.maintenanceReplicasByOrigin.computeIfAbsent(r.getOriginDatanodeId(), k -> new HashSet()).add(r);
                hasOutOfService = true;
                continue;
            }
            hasOutOfService = true;
        }
        this.hasHealthyReplicas = hasHealthy;
        this.hasOutOfServiceReplicas = hasOutOfService;
    }

    public int availableOrigins() {
        return this.replicasByOrigin.size();
    }

    public boolean hasOutOfServiceReplicas() {
        return this.hasOutOfServiceReplicas;
    }

    public boolean hasHealthyReplicas() {
        return this.hasHealthyReplicas;
    }

    public boolean isUnderReplicated() {
        return !this.getUnderReplicatedReplicas().isEmpty();
    }

    private Set<ContainerReplica> getInService(DatanodeID origin) {
        Set<ContainerReplica> set = this.inServiceReplicasByOrigin.get(origin);
        return set == null ? Collections.emptySet() : set;
    }

    private int getMaintenanceCount(DatanodeID origin) {
        Set<ContainerReplica> maintenance = this.maintenanceReplicasByOrigin.get(origin);
        return maintenance == null ? 0 : maintenance.size();
    }

    public List<MisReplicatedOrigin> getUnderReplicatedReplicas() {
        ArrayList<MisReplicatedOrigin> misReplicatedOrigins = new ArrayList<MisReplicatedOrigin>();
        if (this.replicasByOrigin.size() == 1) {
            Map.Entry<DatanodeID, Set<ContainerReplica>> entry = this.replicasByOrigin.entrySet().iterator().next();
            Set<ContainerReplica> inService = this.getInService(entry.getKey());
            int maintenanceCount = this.getMaintenanceCount(entry.getKey());
            if (maintenanceCount > 0) {
                if (inService.size() < this.minHealthyForMaintenance) {
                    int additionalReplicas = this.minHealthyForMaintenance - inService.size();
                    misReplicatedOrigins.add(new MisReplicatedOrigin(entry.getValue(), additionalReplicas));
                }
            } else if (inService.size() < 3) {
                int additionalReplicas = 3 - inService.size();
                misReplicatedOrigins.add(new MisReplicatedOrigin(entry.getValue(), additionalReplicas));
            }
            return misReplicatedOrigins;
        }
        for (Map.Entry<DatanodeID, Set<ContainerReplica>> entry : this.replicasByOrigin.entrySet()) {
            Set<ContainerReplica> inService = this.getInService(entry.getKey());
            int maintenanceCount = this.getMaintenanceCount(entry.getKey());
            if (inService.size() >= 2) continue;
            if (maintenanceCount > 0) {
                if (!inService.isEmpty()) continue;
                misReplicatedOrigins.add(new MisReplicatedOrigin(entry.getValue(), 1));
                continue;
            }
            misReplicatedOrigins.add(new MisReplicatedOrigin(entry.getValue(), 2 - inService.size()));
        }
        return misReplicatedOrigins;
    }

    public boolean isOverReplicated() {
        return !this.getOverReplicatedOrigins().isEmpty();
    }

    public List<MisReplicatedOrigin> getOverReplicatedOrigins() {
        if (this.replicasByOrigin.size() == 1) {
            DatanodeID origin = this.replicasByOrigin.keySet().iterator().next();
            Set<ContainerReplica> inService = this.getInService(origin);
            if (inService.size() > 3) {
                return Collections.singletonList(new MisReplicatedOrigin(inService, inService.size() - 3));
            }
            return Collections.emptyList();
        }
        ArrayList<MisReplicatedOrigin> overReplicatedOrigins = new ArrayList<MisReplicatedOrigin>();
        for (DatanodeID origin : this.replicasByOrigin.keySet()) {
            Set<ContainerReplica> replicas = this.getInService(origin);
            if (replicas.size() <= 2) continue;
            overReplicatedOrigins.add(new MisReplicatedOrigin(replicas, replicas.size() - 2));
        }
        return overReplicatedOrigins;
    }

    public static class MisReplicatedOrigin {
        private final Set<ContainerReplica> sources;
        private final int replicaDelta;

        public MisReplicatedOrigin(Set<ContainerReplica> sources, int replicaDelta) {
            this.sources = sources;
            this.replicaDelta = replicaDelta;
        }

        public Set<ContainerReplica> getSources() {
            return this.sources;
        }

        public int getReplicaDelta() {
            return this.replicaDelta;
        }
    }
}

