/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.container;

import java.io.IOException;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.hdds.scm.container.AbstractContainerReportHandler;
import org.apache.hadoop.hdds.scm.container.ContainerID;
import org.apache.hadoop.hdds.scm.container.ContainerInfo;
import org.apache.hadoop.hdds.scm.container.ContainerManager;
import org.apache.hadoop.hdds.scm.container.ContainerNotFoundException;
import org.apache.hadoop.hdds.scm.container.ContainerReplicaNotFoundException;
import org.apache.hadoop.hdds.scm.container.report.ContainerReportValidator;
import org.apache.hadoop.hdds.scm.exceptions.SCMException;
import org.apache.hadoop.hdds.scm.ha.SCMContext;
import org.apache.hadoop.hdds.scm.node.NodeManager;
import org.apache.hadoop.hdds.scm.node.states.NodeNotFoundException;
import org.apache.hadoop.hdds.scm.server.SCMDatanodeHeartbeatDispatcher;
import org.apache.hadoop.hdds.server.events.EventHandler;
import org.apache.hadoop.hdds.server.events.EventPublisher;
import org.apache.hadoop.ozone.common.statemachine.InvalidStateTransitionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IncrementalContainerReportHandler
extends AbstractContainerReportHandler
implements EventHandler<SCMDatanodeHeartbeatDispatcher.IncrementalContainerReportFromDatanode> {
    private static final Logger LOG = LoggerFactory.getLogger(IncrementalContainerReportHandler.class);

    public IncrementalContainerReportHandler(NodeManager nodeManager, ContainerManager containerManager, SCMContext scmContext) {
        super(nodeManager, containerManager, scmContext);
    }

    @Override
    protected Logger getLogger() {
        return LOG;
    }

    public void onMessage(SCMDatanodeHeartbeatDispatcher.IncrementalContainerReportFromDatanode report, EventPublisher publisher) {
        DatanodeDetails datanode = this.getDatanodeDetails(report);
        if (datanode == null) {
            return;
        }
        this.processICR(report, publisher, datanode);
    }

    protected DatanodeDetails getDatanodeDetails(SCMDatanodeHeartbeatDispatcher.IncrementalContainerReportFromDatanode report) {
        DatanodeDetails dnFromReport = report.getDatanodeDetails();
        this.getLogger().debug("Processing incremental container report from datanode {}", (Object)dnFromReport);
        DatanodeDetails dd = this.getNodeManager().getNode(dnFromReport.getID());
        if (dd == null) {
            this.getLogger().warn("Datanode not found: {}", (Object)dnFromReport);
        }
        return dd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processICR(SCMDatanodeHeartbeatDispatcher.IncrementalContainerReportFromDatanode report, EventPublisher publisher, DatanodeDetails dd) {
        boolean success = false;
        DatanodeDetails datanodeDetails = dd;
        synchronized (datanodeDetails) {
            for (StorageContainerDatanodeProtocolProtos.ContainerReplicaProto replicaProto : ((StorageContainerDatanodeProtocolProtos.IncrementalContainerReportProto)report.getReport()).getReportList()) {
                Object detailsForLogging = IncrementalContainerReportHandler.getDetailsForLogging(null, replicaProto, dd);
                ContainerID id = ContainerID.valueOf((long)replicaProto.getContainerID());
                try {
                    ContainerInfo container;
                    try {
                        container = this.getContainerManager().getContainer(id);
                        id = container.containerID();
                        detailsForLogging = IncrementalContainerReportHandler.getDetailsForLogging(container, replicaProto, dd);
                    }
                    finally {
                        if (replicaProto.getState() == StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State.DELETED) {
                            this.getNodeManager().removeContainer(dd, id);
                        } else {
                            this.getNodeManager().addContainer(dd, id);
                        }
                    }
                    if (ContainerReportValidator.validate(container, dd, replicaProto)) {
                        this.processContainerReplica(dd, container, replicaProto, publisher, detailsForLogging);
                    }
                    success = true;
                }
                catch (ContainerNotFoundException e) {
                    this.getLogger().warn("Container not found: {}", detailsForLogging);
                }
                catch (NodeNotFoundException ex) {
                    this.getLogger().error("{}: {}", (Object)ex, detailsForLogging);
                }
                catch (ContainerReplicaNotFoundException e) {
                    this.getLogger().warn("Container replica not found: {}", detailsForLogging, (Object)e);
                }
                catch (SCMException ex) {
                    if (ex.getResult() == SCMException.ResultCodes.SCM_NOT_LEADER) {
                        this.getLogger().info("SCM_NOT_LEADER: Failed to process {}", detailsForLogging);
                        continue;
                    }
                    this.getLogger().info("Failed to process {}", detailsForLogging, (Object)ex);
                }
                catch (IOException | InvalidStateTransitionException e) {
                    this.getLogger().info("Failed to process {}", detailsForLogging, (Object)e);
                }
            }
        }
        this.getContainerManager().notifyContainerReportProcessing(false, success);
    }
}

