/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.container;

import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.TextFormat;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.hadoop.hdds.client.ECReplicationConfig;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.DatanodeID;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.hdds.scm.container.ContainerID;
import org.apache.hadoop.hdds.scm.container.ContainerInfo;
import org.apache.hadoop.hdds.scm.container.ContainerManager;
import org.apache.hadoop.hdds.scm.container.ContainerNotFoundException;
import org.apache.hadoop.hdds.scm.container.ContainerReplica;
import org.apache.hadoop.hdds.scm.container.ContainerReplicaNotFoundException;
import org.apache.hadoop.hdds.scm.events.SCMEvents;
import org.apache.hadoop.hdds.scm.ha.SCMContext;
import org.apache.hadoop.hdds.scm.node.NodeManager;
import org.apache.hadoop.hdds.server.events.EventPublisher;
import org.apache.hadoop.ozone.common.statemachine.InvalidStateTransitionException;
import org.apache.hadoop.ozone.protocol.commands.CommandForDatanode;
import org.apache.hadoop.ozone.protocol.commands.DeleteContainerCommand;
import org.apache.hadoop.ozone.protocol.commands.SCMCommand;
import org.apache.ratis.protocol.exceptions.NotLeaderException;
import org.apache.ratis.util.MemoizedSupplier;
import org.apache.ratis.util.Preconditions;
import org.slf4j.Logger;

abstract class AbstractContainerReportHandler {
    private final NodeManager nodeManager;
    private final ContainerManager containerManager;
    private final SCMContext scmContext;

    AbstractContainerReportHandler(NodeManager nodeManager, ContainerManager containerManager, SCMContext scmContext) {
        this.nodeManager = Objects.requireNonNull(nodeManager, "nodeManager == null");
        this.containerManager = Objects.requireNonNull(containerManager, "containerManager == null");
        this.scmContext = Objects.requireNonNull(scmContext, "scmContext == null");
    }

    protected abstract Logger getLogger();

    protected static Object getDetailsForLogging(ContainerInfo container, StorageContainerDatanodeProtocolProtos.ContainerReplicaProto replica, DatanodeDetails datanode) {
        Objects.requireNonNull(replica, "replica == null");
        Objects.requireNonNull(datanode, "datanode == null");
        if (container != null) {
            Preconditions.assertSame((long)container.getContainerID(), (long)replica.getContainerID(), (String)"Container ID");
        }
        MemoizedSupplier details = MemoizedSupplier.valueOf(() -> {
            StringBuilder b = new StringBuilder();
            if (container == null) {
                b.append("Container #").append(replica.getContainerID()).append(" (NOT_FOUND");
            } else {
                b.append("Container ").append(container.containerID()).append(" (").append(container.getState()).append(", sid=").append(container.getSequenceId());
            }
            return b.append(") r").append(replica.getReplicaIndex()).append(" (").append(replica.getState()).append(", bcsid=").append(replica.getBlockCommitSequenceId()).append(", origin=").append(replica.getOriginNodeId()).append(", ").append(replica.hasIsEmpty() && replica.getIsEmpty() ? "empty" : "non-empty").append(") from dn ").append(datanode).toString();
        });
        return new Object((Supplier)details){
            final /* synthetic */ Supplier val$details;
            {
                this.val$details = supplier;
            }

            public String toString() {
                return (String)this.val$details.get();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processContainerReplica(DatanodeDetails datanodeDetails, ContainerInfo containerInfo, StorageContainerDatanodeProtocolProtos.ContainerReplicaProto replicaProto, EventPublisher publisher, Object detailsForLogging) throws IOException, InvalidStateTransitionException {
        this.getLogger().debug("Processing replica {}", detailsForLogging);
        ContainerInfo containerInfo2 = containerInfo;
        synchronized (containerInfo2) {
            this.updateContainerStats(datanodeDetails, containerInfo, replicaProto, detailsForLogging);
            if (!this.updateContainerState(datanodeDetails, containerInfo, replicaProto, publisher, detailsForLogging)) {
                this.updateContainerReplica(datanodeDetails, containerInfo.containerID(), replicaProto);
            }
        }
    }

    private void updateContainerStats(DatanodeDetails datanodeDetails, ContainerInfo containerInfo, StorageContainerDatanodeProtocolProtos.ContainerReplicaProto replicaProto, Object detailsForLogging) throws ContainerNotFoundException {
        if (containerInfo.getState() == HddsProtos.LifeCycleState.CLOSED && containerInfo.getSequenceId() < replicaProto.getBlockCommitSequenceId()) {
            this.getLogger().error("Container CLOSED with sequence ID lower than a replica: {}, proto={}", detailsForLogging, (Object)TextFormat.shortDebugString((MessageOrBuilder)replicaProto));
        }
        if (this.isHealthy(replicaProto.getState())) {
            if (containerInfo.getSequenceId() < replicaProto.getBlockCommitSequenceId()) {
                containerInfo.updateSequenceId(replicaProto.getBlockCommitSequenceId());
            }
            if (containerInfo.getReplicationConfig().getReplicationType() == HddsProtos.ReplicationType.EC) {
                this.updateECContainerStats(containerInfo, replicaProto, datanodeDetails);
            } else {
                this.updateRatisContainerStats(containerInfo, replicaProto, datanodeDetails);
            }
        }
    }

    private void updateRatisContainerStats(ContainerInfo containerInfo, StorageContainerDatanodeProtocolProtos.ContainerReplicaProto newReplica, DatanodeDetails newSource) throws ContainerNotFoundException {
        List<ContainerReplica> otherReplicas = this.getOtherReplicas(containerInfo.containerID(), newSource);
        long usedBytes = newReplica.getUsed();
        long keyCount = newReplica.getKeyCount();
        for (ContainerReplica r : otherReplicas) {
            usedBytes = AbstractContainerReportHandler.calculateUsage(containerInfo, usedBytes, r.getBytesUsed());
            keyCount = AbstractContainerReportHandler.calculateUsage(containerInfo, keyCount, r.getKeyCount());
        }
        AbstractContainerReportHandler.updateContainerUsedAndKeys(containerInfo, usedBytes, keyCount);
    }

    private void updateECContainerStats(ContainerInfo containerInfo, StorageContainerDatanodeProtocolProtos.ContainerReplicaProto newReplica, DatanodeDetails newSource) throws ContainerNotFoundException {
        int dataNum = ((ECReplicationConfig)containerInfo.getReplicationConfig()).getData();
        if (newReplica.getReplicaIndex() == 1 || newReplica.getReplicaIndex() > dataNum) {
            List<ContainerReplica> otherReplicas = this.getOtherReplicas(containerInfo.containerID(), newSource);
            long usedBytes = newReplica.getUsed();
            long keyCount = newReplica.getKeyCount();
            for (ContainerReplica r : otherReplicas) {
                if (r.getReplicaIndex() > 1 && r.getReplicaIndex() <= dataNum) continue;
                usedBytes = AbstractContainerReportHandler.calculateUsage(containerInfo, usedBytes, r.getBytesUsed());
                keyCount = AbstractContainerReportHandler.calculateUsage(containerInfo, keyCount, r.getKeyCount());
            }
            AbstractContainerReportHandler.updateContainerUsedAndKeys(containerInfo, usedBytes, keyCount);
        }
    }

    private static long calculateUsage(ContainerInfo containerInfo, long lastValue, long thisValue) {
        if (containerInfo.getState().equals((Object)HddsProtos.LifeCycleState.OPEN)) {
            return Math.min(lastValue, thisValue);
        }
        return Math.max(lastValue, thisValue);
    }

    private static void updateContainerUsedAndKeys(ContainerInfo containerInfo, long usedBytes, long keyCount) {
        if (containerInfo.getUsedBytes() != usedBytes) {
            containerInfo.setUsedBytes(usedBytes);
        }
        if (containerInfo.getNumberOfKeys() != keyCount) {
            containerInfo.setNumberOfKeys(keyCount);
        }
    }

    private List<ContainerReplica> getOtherReplicas(ContainerID containerId, DatanodeDetails exclude) throws ContainerNotFoundException {
        ArrayList<ContainerReplica> filteredReplicas = new ArrayList<ContainerReplica>();
        Set<ContainerReplica> replicas = this.containerManager.getContainerReplicas(containerId);
        for (ContainerReplica r : replicas) {
            if (r.getDatanodeDetails().equals((Object)exclude)) continue;
            filteredReplicas.add(r);
        }
        return filteredReplicas;
    }

    private boolean updateContainerState(DatanodeDetails datanode, ContainerInfo container, StorageContainerDatanodeProtocolProtos.ContainerReplicaProto replica, EventPublisher publisher, Object detailsForLogging) throws IOException, InvalidStateTransitionException {
        ContainerID containerId = container.containerID();
        boolean replicaIsEmpty = replica.hasIsEmpty() && replica.getIsEmpty();
        switch (container.getState()) {
            case OPEN: {
                if (replica.getState() != StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State.OPEN) {
                    this.getLogger().info("FINALIZE (i.e. CLOSING) {}", detailsForLogging);
                    this.containerManager.updateContainerState(containerId, HddsProtos.LifeCycleEvent.FINALIZE);
                }
                return false;
            }
            case CLOSING: {
                if (replica.getState() == StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State.QUASI_CLOSED) {
                    this.getLogger().info("QUASI_CLOSE {}", detailsForLogging);
                    this.containerManager.updateContainerState(containerId, HddsProtos.LifeCycleEvent.QUASI_CLOSE);
                    return false;
                }
                if (replica.getState() == StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State.CLOSED) {
                    if (container.getReplicationType().equals((Object)HddsProtos.ReplicationType.EC)) {
                        int replicaIndex = replica.getReplicaIndex();
                        int dataNum = ((ECReplicationConfig)container.getReplicationConfig()).getData();
                        if (replicaIndex != 1 && replicaIndex <= dataNum) {
                            return false;
                        }
                    }
                    if (this.bcsidMismatched(container, replica, detailsForLogging)) {
                        return true;
                    }
                    this.getLogger().info("CLOSE {}", detailsForLogging);
                    this.containerManager.updateContainerState(containerId, HddsProtos.LifeCycleEvent.CLOSE);
                }
                return false;
            }
            case QUASI_CLOSED: {
                if (replica.getState() == StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State.CLOSED) {
                    if (this.bcsidMismatched(container, replica, detailsForLogging)) {
                        return true;
                    }
                    this.getLogger().info("FORCE_CLOSE for {}", detailsForLogging);
                    this.containerManager.updateContainerState(containerId, HddsProtos.LifeCycleEvent.FORCE_CLOSE);
                }
                return false;
            }
            case CLOSED: {
                return false;
            }
            case DELETED: {
                if (replicaIsEmpty) {
                    this.deleteReplica(containerId, datanode, publisher, "DELETED", false, detailsForLogging);
                    return false;
                }
            }
            case DELETING: {
                boolean replicaStateAllowed;
                boolean bl = replicaStateAllowed = replica.getState() != StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State.INVALID && replica.getState() != StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State.DELETED;
                if (!replicaIsEmpty && replicaStateAllowed) {
                    this.getLogger().info("transitionDeletingToClosed due to non-empty CLOSED replica (keyCount={}) for {}", (Object)replica.getKeyCount(), detailsForLogging);
                    this.containerManager.transitionDeletingOrDeletedToClosedState(containerId);
                }
                return false;
            }
        }
        this.getLogger().error("Replica not processed due to container state {}: {}", (Object)container.getState(), detailsForLogging);
        return false;
    }

    private boolean bcsidMismatched(ContainerInfo container, StorageContainerDatanodeProtocolProtos.ContainerReplicaProto replica, Object detailsForLogging) {
        if (replica.getBlockCommitSequenceId() == container.getSequenceId()) {
            return false;
        }
        this.getLogger().warn("Replica BCSID mismatched for {} ", detailsForLogging);
        return true;
    }

    private void updateContainerReplica(DatanodeDetails datanodeDetails, ContainerID containerId, StorageContainerDatanodeProtocolProtos.ContainerReplicaProto replicaProto) throws ContainerNotFoundException, ContainerReplicaNotFoundException {
        ContainerReplica replica = ContainerReplica.newBuilder().setContainerID(containerId).setContainerState(replicaProto.getState()).setDatanodeDetails(datanodeDetails).setOriginNodeId(DatanodeID.fromUuidString((String)replicaProto.getOriginNodeId())).setSequenceId(replicaProto.getBlockCommitSequenceId()).setKeyCount(replicaProto.getKeyCount()).setReplicaIndex(replicaProto.getReplicaIndex()).setBytesUsed(replicaProto.getUsed()).setEmpty(replicaProto.getIsEmpty()).setDataChecksum(replicaProto.getDataChecksum()).build();
        if (replica.getState().equals((Object)StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State.DELETED)) {
            this.containerManager.removeContainerReplica(containerId, replica);
        } else {
            this.containerManager.updateContainerReplica(containerId, replica);
        }
    }

    private boolean isHealthy(StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State replicaState) {
        return replicaState != StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State.UNHEALTHY && replicaState != StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State.INVALID && replicaState != StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State.DELETED;
    }

    protected NodeManager getNodeManager() {
        return this.nodeManager;
    }

    protected ContainerManager getContainerManager() {
        return this.containerManager;
    }

    protected void deleteReplica(ContainerID containerID, DatanodeDetails dn, EventPublisher publisher, String reason, boolean force, Object detailsForLogging) {
        long term;
        try {
            term = this.scmContext.getTermOfLeader();
        }
        catch (NotLeaderException nle) {
            String message = "Skip sending DeleteContainerCommand for " + detailsForLogging + ": " + (Object)((Object)nle);
            this.getLogger().warn(message);
            return;
        }
        DeleteContainerCommand command = new DeleteContainerCommand(containerID, force);
        command.setTerm(term);
        publisher.fireEvent(SCMEvents.DATANODE_COMMAND, (Object)new CommandForDatanode(dn, (SCMCommand)command));
        this.getLogger().info("Sending {}DeleteContainerCommand due to {} for {}", new Object[]{force ? "force" : "", reason, detailsForLogging});
    }
}

