/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.server;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.math.BigInteger;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.protocol.proto.SCMRatisProtocol;
import org.apache.hadoop.hdds.scm.ha.SCMRatisServer;
import org.apache.hadoop.hdds.scm.metadata.SCMMetadataStore;
import org.apache.hadoop.hdds.security.exception.SCMSecurityException;
import org.apache.hadoop.hdds.security.x509.certificate.authority.CertificateStore;
import org.apache.hadoop.hdds.utils.MetadataKeyFilters;
import org.apache.hadoop.hdds.utils.db.BatchOperation;
import org.apache.hadoop.hdds.utils.db.Table;
import org.apache.hadoop.hdds.utils.db.TableIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SCMCertStore
implements CertificateStore {
    private static final Logger LOG = LoggerFactory.getLogger(SCMCertStore.class);
    private SCMMetadataStore scmMetadataStore;
    private final Lock lock;

    private SCMCertStore(SCMMetadataStore dbStore) {
        this.scmMetadataStore = dbStore;
        this.lock = new ReentrantLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeValidCertificate(BigInteger serialID, X509Certificate certificate, HddsProtos.NodeType role) throws IOException {
        this.lock.lock();
        try {
            if (role == HddsProtos.NodeType.SCM) {
                this.storeValidScmCertificate(serialID, certificate);
            } else {
                this.scmMetadataStore.getValidCertsTable().put((Object)serialID, (Object)certificate);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeValidScmCertificate(BigInteger serialID, X509Certificate certificate) throws IOException {
        this.lock.lock();
        try (BatchOperation batchOperation = this.scmMetadataStore.getBatchHandler().initBatchOperation();){
            this.scmMetadataStore.getValidSCMCertsTable().putWithBatch(batchOperation, (Object)serialID, (Object)certificate);
            this.scmMetadataStore.getValidCertsTable().putWithBatch(batchOperation, (Object)serialID, (Object)certificate);
            this.scmMetadataStore.getStore().commitBatchOperation(batchOperation);
            LOG.info("Scm certificate {} for {} is stored", (Object)serialID, (Object)certificate.getSubjectDN());
        }
        finally {
            this.lock.unlock();
        }
    }

    public void checkValidCertID(BigInteger serialID) throws IOException {
        this.lock.lock();
        try {
            if (this.getCertificateByID(serialID) != null) {
                throw new SCMSecurityException("Conflicting certificate ID" + serialID);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<X509Certificate> removeAllExpiredCertificates() throws IOException {
        ArrayList<X509Certificate> removedCerts = new ArrayList<X509Certificate>();
        this.lock.lock();
        try (BatchOperation batchOperation = this.scmMetadataStore.getBatchHandler().initBatchOperation();){
            removedCerts.addAll(this.addExpiredCertsToBeRemoved(batchOperation, (Table<BigInteger, X509Certificate>)this.scmMetadataStore.getValidCertsTable()));
            removedCerts.addAll(this.addExpiredCertsToBeRemoved(batchOperation, (Table<BigInteger, X509Certificate>)this.scmMetadataStore.getValidSCMCertsTable()));
            this.scmMetadataStore.getStore().commitBatchOperation(batchOperation);
        }
        finally {
            this.lock.unlock();
        }
        return removedCerts;
    }

    private List<X509Certificate> addExpiredCertsToBeRemoved(BatchOperation batchOperation, Table<BigInteger, X509Certificate> certTable) throws IOException {
        ArrayList<X509Certificate> removedCerts = new ArrayList<X509Certificate>();
        try (TableIterator certsIterator = certTable.iterator();){
            Date now = new Date();
            while (certsIterator.hasNext()) {
                Table.KeyValue certEntry = (Table.KeyValue)certsIterator.next();
                X509Certificate cert = (X509Certificate)certEntry.getValue();
                if (!cert.getNotAfter().before(now)) continue;
                removedCerts.add(cert);
                certTable.deleteWithBatch(batchOperation, certEntry.getKey());
            }
        }
        return removedCerts;
    }

    public X509Certificate getCertificateByID(BigInteger serialID) throws IOException {
        return (X509Certificate)this.scmMetadataStore.getValidCertsTable().get((Object)serialID);
    }

    public List<X509Certificate> listCertificate(HddsProtos.NodeType role, BigInteger startSerialID, int count) throws IOException {
        ArrayList<X509Certificate> results = new ArrayList<X509Certificate>();
        String errorMessage = "Fail to list certificate from SCM metadata store";
        Preconditions.checkNotNull((Object)startSerialID);
        if (startSerialID.longValue() == 0L) {
            startSerialID = null;
        }
        for (Table.KeyValue<BigInteger, X509Certificate> keyValue : this.getValidCertTableList(role, startSerialID, count)) {
            try {
                X509Certificate cert = (X509Certificate)keyValue.getValue();
                results.add(cert);
            }
            catch (IOException e) {
                LOG.error(errorMessage, (Throwable)e);
                throw new SCMSecurityException(errorMessage);
            }
        }
        return results;
    }

    private List<? extends Table.KeyValue<BigInteger, X509Certificate>> getValidCertTableList(HddsProtos.NodeType role, BigInteger startSerialID, int count) throws IOException {
        if (role == HddsProtos.NodeType.SCM) {
            return this.scmMetadataStore.getValidSCMCertsTable().getRangeKVs((Object)startSerialID, count, null, new MetadataKeyFilters.MetadataKeyFilter[0]);
        }
        return this.scmMetadataStore.getValidCertsTable().getRangeKVs((Object)startSerialID, count, null, new MetadataKeyFilters.MetadataKeyFilter[0]);
    }

    public void reinitialize(SCMMetadataStore metadataStore) {
        this.scmMetadataStore = metadataStore;
    }

    public static class Builder {
        private SCMMetadataStore metadataStore;
        private SCMRatisServer scmRatisServer;

        public Builder setMetadaStore(SCMMetadataStore scmMetadataStore) {
            this.metadataStore = scmMetadataStore;
            return this;
        }

        public Builder setRatisServer(SCMRatisServer ratisServer) {
            this.scmRatisServer = ratisServer;
            return this;
        }

        public CertificateStore build() {
            SCMCertStore scmCertStore = new SCMCertStore(this.metadataStore);
            return this.scmRatisServer.getProxyHandler(SCMRatisProtocol.RequestType.CERT_STORE, CertificateStore.class, scmCertStore);
        }
    }
}

