/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.safemode;

import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.MutableCounterLong;
import org.apache.hadoop.metrics2.lib.MutableGaugeLong;

public class SafeModeMetrics {
    private static final String SOURCE_NAME = SafeModeMetrics.class.getSimpleName();
    @Metric
    private MutableGaugeLong numContainerWithOneReplicaReportedThreshold;
    @Metric
    private MutableGaugeLong numContainerWithECDataReplicaReportedThreshold;
    @Metric
    private MutableCounterLong currentContainersWithOneReplicaReportedCount;
    @Metric
    private MutableCounterLong currentContainersWithECDataReplicaReportedCount;
    @Metric
    private MutableGaugeLong numHealthyPipelinesThreshold;
    @Metric
    private MutableCounterLong currentHealthyPipelinesCount;
    @Metric
    private MutableGaugeLong numPipelinesWithAtleastOneReplicaReportedThreshold;
    @Metric
    private MutableCounterLong currentPipelinesWithAtleastOneReplicaReportedCount;

    public static SafeModeMetrics create() {
        MetricsSystem ms = DefaultMetricsSystem.instance();
        return (SafeModeMetrics)ms.register(SOURCE_NAME, "SCM Safemode Metrics", (Object)new SafeModeMetrics());
    }

    public void setNumHealthyPipelinesThreshold(long val) {
        this.numHealthyPipelinesThreshold.set(val);
    }

    public void incCurrentHealthyPipelinesCount() {
        this.currentHealthyPipelinesCount.incr();
    }

    public void setNumPipelinesWithAtleastOneReplicaReportedThreshold(long val) {
        this.numPipelinesWithAtleastOneReplicaReportedThreshold.set(val);
    }

    public void incCurrentHealthyPipelinesWithAtleastOneReplicaReportedCount() {
        this.currentPipelinesWithAtleastOneReplicaReportedCount.incr();
    }

    public void setNumContainerWithOneReplicaReportedThreshold(long val) {
        this.numContainerWithOneReplicaReportedThreshold.set(val);
    }

    public void setNumContainerWithECDataReplicaReportedThreshold(long val) {
        this.numContainerWithECDataReplicaReportedThreshold.set(val);
    }

    public void incCurrentContainersWithOneReplicaReportedCount() {
        this.currentContainersWithOneReplicaReportedCount.incr();
    }

    public void incCurrentContainersWithECDataReplicaReportedCount() {
        this.currentContainersWithECDataReplicaReportedCount.incr();
    }

    MutableGaugeLong getNumHealthyPipelinesThreshold() {
        return this.numHealthyPipelinesThreshold;
    }

    MutableCounterLong getCurrentHealthyPipelinesCount() {
        return this.currentHealthyPipelinesCount;
    }

    MutableGaugeLong getNumPipelinesWithAtleastOneReplicaReportedThreshold() {
        return this.numPipelinesWithAtleastOneReplicaReportedThreshold;
    }

    MutableCounterLong getCurrentPipelinesWithAtleastOneReplicaCount() {
        return this.currentPipelinesWithAtleastOneReplicaReportedCount;
    }

    MutableGaugeLong getNumContainerWithOneReplicaReportedThreshold() {
        return this.numContainerWithOneReplicaReportedThreshold;
    }

    MutableGaugeLong getNumContainerWithECDataReplicaReportedThreshold() {
        return this.numContainerWithECDataReplicaReportedThreshold;
    }

    MutableCounterLong getCurrentContainersWithOneReplicaReportedCount() {
        return this.currentContainersWithOneReplicaReportedCount;
    }

    public void unRegister() {
        MetricsSystem ms = DefaultMetricsSystem.instance();
        ms.unregisterSource(SOURCE_NAME);
    }
}

