/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.ha;

import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.hadoop.hdds.protocol.scm.proto.InterSCMProtocolProtos;
import org.apache.ratis.thirdparty.com.google.protobuf.ByteString;
import org.apache.ratis.thirdparty.io.grpc.stub.StreamObserver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SCMGrpcOutputStream
extends OutputStream {
    private static final Logger LOG = LoggerFactory.getLogger(SCMGrpcOutputStream.class);
    private final StreamObserver<InterSCMProtocolProtos.CopyDBCheckpointResponseProto> responseObserver;
    private final ByteString.Output buffer;
    private final String clusterId;
    private final int bufferSize;
    private long writtenBytes;

    SCMGrpcOutputStream(StreamObserver<InterSCMProtocolProtos.CopyDBCheckpointResponseProto> responseObserver, String clusterId, int bufferSize) {
        this.responseObserver = responseObserver;
        this.clusterId = clusterId;
        this.bufferSize = bufferSize;
        this.buffer = ByteString.newOutput((int)bufferSize);
    }

    @Override
    public void write(int b) {
        try {
            this.buffer.write(b);
            if (this.buffer.size() >= this.bufferSize) {
                this.flushBuffer(false);
            }
        }
        catch (Exception ex) {
            this.responseObserver.onError((Throwable)ex);
        }
    }

    @Override
    public void write(@Nonnull byte[] data, int offset, int length) {
        if (offset < 0 || offset > data.length || length < 0 || offset + length > data.length || offset + length < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (length == 0) {
            return;
        }
        try {
            if (this.buffer.size() >= this.bufferSize) {
                this.flushBuffer(false);
            }
            int remaining = length;
            int off = offset;
            int len = Math.min(remaining, this.bufferSize - this.buffer.size());
            while (remaining > 0) {
                this.buffer.write(data, off, len);
                if (this.buffer.size() >= this.bufferSize) {
                    this.flushBuffer(false);
                }
                off += len;
                len = Math.min(this.bufferSize, remaining -= len);
            }
        }
        catch (Exception ex) {
            this.responseObserver.onError((Throwable)ex);
        }
    }

    @Override
    public void close() throws IOException {
        this.flushBuffer(true);
        LOG.info("Sent {} bytes for cluster {}", (Object)this.writtenBytes, (Object)this.clusterId);
        this.responseObserver.onCompleted();
        this.buffer.close();
    }

    private void flushBuffer(boolean eof) {
        int length = this.buffer.size();
        if (length > 0) {
            ByteString data = this.buffer.toByteString();
            LOG.debug("Sending {} bytes (of type {})", (Object)length, (Object)data.getClass().getSimpleName());
            InterSCMProtocolProtos.CopyDBCheckpointResponseProto response = InterSCMProtocolProtos.CopyDBCheckpointResponseProto.newBuilder().setClusterId(this.clusterId).setData(data).setEof(eof).setReadOffset(this.writtenBytes).setLen((long)length).build();
            this.responseObserver.onNext((Object)response);
            this.writtenBytes += (long)length;
            this.buffer.reset();
        }
    }
}

