/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.container.replication;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.hdds.scm.container.ContainerReplica;

public class QuasiClosedStuckReplicaCount {
    private final Map<UUID, Set<ContainerReplica>> replicasByOrigin = new HashMap<UUID, Set<ContainerReplica>>();
    private final Map<UUID, Set<ContainerReplica>> inServiceReplicasByOrigin = new HashMap<UUID, Set<ContainerReplica>>();
    private final Map<UUID, Set<ContainerReplica>> maintenanceReplicasByOrigin = new HashMap<UUID, Set<ContainerReplica>>();
    private boolean hasOutOfServiceReplicas = false;
    private int minHealthyForMaintenance;
    private boolean hasHealthyReplicas = false;

    public QuasiClosedStuckReplicaCount(Set<ContainerReplica> replicas, int minHealthyForMaintenance) {
        this.minHealthyForMaintenance = minHealthyForMaintenance;
        for (ContainerReplica r : replicas) {
            if (r.getState() != StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State.UNHEALTHY) {
                this.hasHealthyReplicas = true;
            }
            this.replicasByOrigin.computeIfAbsent(r.getOriginDatanodeId(), k -> new HashSet()).add(r);
            HddsProtos.NodeOperationalState opState = r.getDatanodeDetails().getPersistedOpState();
            if (opState == HddsProtos.NodeOperationalState.IN_SERVICE) {
                this.inServiceReplicasByOrigin.computeIfAbsent(r.getOriginDatanodeId(), k -> new HashSet()).add(r);
                continue;
            }
            if (opState == HddsProtos.NodeOperationalState.IN_MAINTENANCE || opState == HddsProtos.NodeOperationalState.ENTERING_MAINTENANCE) {
                this.maintenanceReplicasByOrigin.computeIfAbsent(r.getOriginDatanodeId(), k -> new HashSet()).add(r);
                this.hasOutOfServiceReplicas = true;
                continue;
            }
            this.hasOutOfServiceReplicas = true;
        }
    }

    public int availableOrigins() {
        return this.replicasByOrigin.size();
    }

    public boolean hasOutOfServiceReplicas() {
        return this.hasOutOfServiceReplicas;
    }

    public boolean hasHealthyReplicas() {
        return this.hasHealthyReplicas;
    }

    public boolean isUnderReplicated() {
        return !this.getUnderReplicatedReplicas().isEmpty();
    }

    public List<MisReplicatedOrigin> getUnderReplicatedReplicas() {
        ArrayList<MisReplicatedOrigin> misReplicatedOrigins = new ArrayList<MisReplicatedOrigin>();
        if (this.replicasByOrigin.size() == 1) {
            Set<ContainerReplica> maintenance;
            int maintenanceCount;
            Map.Entry<UUID, Set<ContainerReplica>> entry = this.replicasByOrigin.entrySet().iterator().next();
            Set<ContainerReplica> inService = this.inServiceReplicasByOrigin.get(entry.getKey());
            if (inService == null) {
                inService = Collections.emptySet();
            }
            int n = maintenanceCount = (maintenance = this.maintenanceReplicasByOrigin.get(entry.getKey())) == null ? 0 : maintenance.size();
            if (maintenanceCount > 0) {
                if (inService.size() < this.minHealthyForMaintenance) {
                    int additionalReplicas = this.minHealthyForMaintenance - inService.size();
                    misReplicatedOrigins.add(new MisReplicatedOrigin(entry.getValue(), additionalReplicas));
                }
            } else if (inService.size() < 3) {
                int additionalReplicas = 3 - inService.size();
                misReplicatedOrigins.add(new MisReplicatedOrigin(entry.getValue(), additionalReplicas));
            }
            return misReplicatedOrigins;
        }
        for (Map.Entry<UUID, Set<ContainerReplica>> entry : this.replicasByOrigin.entrySet()) {
            Set<ContainerReplica> maintenance;
            int maintenanceCount;
            Set<ContainerReplica> inService = this.inServiceReplicasByOrigin.get(entry.getKey());
            if (inService == null) {
                inService = Collections.emptySet();
            }
            int n = maintenanceCount = (maintenance = this.maintenanceReplicasByOrigin.get(entry.getKey())) == null ? 0 : maintenance.size();
            if (inService.size() >= 2) continue;
            if (maintenanceCount > 0) {
                if (!inService.isEmpty()) continue;
                misReplicatedOrigins.add(new MisReplicatedOrigin(entry.getValue(), 1));
                continue;
            }
            misReplicatedOrigins.add(new MisReplicatedOrigin(entry.getValue(), 2 - inService.size()));
        }
        return misReplicatedOrigins;
    }

    public boolean isOverReplicated() {
        return !this.getOverReplicatedOrigins().isEmpty();
    }

    public List<MisReplicatedOrigin> getOverReplicatedOrigins() {
        if (this.replicasByOrigin.size() == 1) {
            UUID origin = this.replicasByOrigin.keySet().iterator().next();
            Set<ContainerReplica> inService = this.inServiceReplicasByOrigin.get(origin);
            if (inService != null && inService.size() > 3) {
                return Collections.singletonList(new MisReplicatedOrigin(inService, inService.size() - 3));
            }
            return Collections.emptyList();
        }
        ArrayList<MisReplicatedOrigin> overReplicatedOrigins = new ArrayList<MisReplicatedOrigin>();
        for (UUID origin : this.replicasByOrigin.keySet()) {
            Set<ContainerReplica> replicas = this.inServiceReplicasByOrigin.get(origin);
            if (replicas == null || replicas.size() <= 2) continue;
            overReplicatedOrigins.add(new MisReplicatedOrigin(replicas, replicas.size() - 2));
        }
        return overReplicatedOrigins;
    }

    public static class MisReplicatedOrigin {
        private final Set<ContainerReplica> sources;
        private final int replicaDelta;

        public MisReplicatedOrigin(Set<ContainerReplica> sources, int replicaDelta) {
            this.sources = sources;
            this.replicaDelta = replicaDelta;
        }

        public Set<ContainerReplica> getSources() {
            return this.sources;
        }

        public int getReplicaDelta() {
            return this.replicaDelta;
        }
    }
}

