/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.container;

import java.io.IOException;
import java.util.concurrent.TimeoutException;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.hdds.scm.container.AbstractContainerReportHandler;
import org.apache.hadoop.hdds.scm.container.ContainerID;
import org.apache.hadoop.hdds.scm.container.ContainerInfo;
import org.apache.hadoop.hdds.scm.container.ContainerManager;
import org.apache.hadoop.hdds.scm.container.ContainerNotFoundException;
import org.apache.hadoop.hdds.scm.container.ContainerReplicaNotFoundException;
import org.apache.hadoop.hdds.scm.container.report.ContainerReportValidator;
import org.apache.hadoop.hdds.scm.exceptions.SCMException;
import org.apache.hadoop.hdds.scm.ha.SCMContext;
import org.apache.hadoop.hdds.scm.node.NodeManager;
import org.apache.hadoop.hdds.scm.node.states.NodeNotFoundException;
import org.apache.hadoop.hdds.scm.server.SCMDatanodeHeartbeatDispatcher;
import org.apache.hadoop.hdds.server.events.EventHandler;
import org.apache.hadoop.hdds.server.events.EventPublisher;
import org.apache.hadoop.ozone.common.statemachine.InvalidStateTransitionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IncrementalContainerReportHandler
extends AbstractContainerReportHandler
implements EventHandler<SCMDatanodeHeartbeatDispatcher.IncrementalContainerReportFromDatanode> {
    private static final Logger LOG = LoggerFactory.getLogger(IncrementalContainerReportHandler.class);
    private final NodeManager nodeManager;

    public IncrementalContainerReportHandler(NodeManager nodeManager, ContainerManager containerManager, SCMContext scmContext) {
        super(containerManager, scmContext, LOG);
        this.nodeManager = nodeManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(SCMDatanodeHeartbeatDispatcher.IncrementalContainerReportFromDatanode report, EventPublisher publisher) {
        DatanodeDetails dd;
        DatanodeDetails dnFromReport = report.getDatanodeDetails();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Processing incremental container report from data node {}", (Object)dnFromReport.getUuid());
        }
        if ((dd = this.nodeManager.getNodeByUuid(dnFromReport.getUuid())) == null) {
            LOG.warn("Received container report from unknown datanode {}", (Object)dnFromReport);
            return;
        }
        boolean success = false;
        DatanodeDetails datanodeDetails = dd;
        synchronized (datanodeDetails) {
            for (StorageContainerDatanodeProtocolProtos.ContainerReplicaProto replicaProto : ((StorageContainerDatanodeProtocolProtos.IncrementalContainerReportProto)report.getReport()).getReportList()) {
                ContainerID id = ContainerID.valueOf((long)replicaProto.getContainerID());
                ContainerInfo container = null;
                try {
                    try {
                        container = this.getContainerManager().getContainer(id);
                        id = container.containerID();
                    }
                    finally {
                        if (replicaProto.getState().equals((Object)StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State.DELETED)) {
                            this.nodeManager.removeContainer(dd, id);
                        } else {
                            this.nodeManager.addContainer(dd, id);
                        }
                    }
                    if (ContainerReportValidator.validate(container, dd, replicaProto)) {
                        this.processContainerReplica(dd, container, replicaProto, publisher);
                    }
                    success = true;
                }
                catch (ContainerNotFoundException e) {
                    LOG.warn("Container {} not found!", (Object)replicaProto.getContainerID());
                }
                catch (NodeNotFoundException ex) {
                    LOG.error("Received ICR from unknown datanode {}", (Object)report.getDatanodeDetails(), (Object)ex);
                }
                catch (ContainerReplicaNotFoundException e) {
                    LOG.warn("Container {} replica not found!", (Object)replicaProto.getContainerID());
                }
                catch (SCMException ex) {
                    if (ex.getResult() == SCMException.ResultCodes.SCM_NOT_LEADER) {
                        LOG.info("Failed to process {} container {}: {}", new Object[]{replicaProto.getState(), id, ex.getMessage()});
                        continue;
                    }
                    LOG.error("Exception while processing ICR for container {}", (Object)replicaProto.getContainerID(), (Object)ex);
                }
                catch (IOException | TimeoutException | InvalidStateTransitionException e) {
                    LOG.error("Exception while processing ICR for container {}", (Object)replicaProto.getContainerID(), (Object)e);
                }
            }
        }
        this.getContainerManager().notifyContainerReportProcessing(false, success);
    }

    protected NodeManager getNodeManager() {
        return this.nodeManager;
    }
}

