/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.container;

import java.io.Closeable;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.hdds.client.ReplicationConfig;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.container.ContainerID;
import org.apache.hadoop.hdds.scm.container.ContainerInfo;
import org.apache.hadoop.hdds.scm.container.ContainerNotFoundException;
import org.apache.hadoop.hdds.scm.container.ContainerReplica;
import org.apache.hadoop.hdds.scm.container.ContainerReplicaNotFoundException;
import org.apache.hadoop.hdds.scm.container.ContainerStateManager;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.utils.db.Table;
import org.apache.hadoop.ozone.common.statemachine.InvalidStateTransitionException;

public interface ContainerManager
extends Closeable {
    public void reinitialize(Table<ContainerID, ContainerInfo> var1) throws IOException;

    public ContainerInfo getContainer(ContainerID var1) throws ContainerNotFoundException;

    default public List<ContainerInfo> getContainers() {
        return this.getContainers(ContainerID.valueOf((long)0L), Integer.MAX_VALUE);
    }

    public List<ContainerInfo> getContainers(ContainerID var1, int var2);

    public List<ContainerInfo> getContainers(HddsProtos.ReplicationType var1);

    public List<ContainerInfo> getContainers(HddsProtos.LifeCycleState var1);

    public List<ContainerInfo> getContainers(ContainerID var1, int var2, HddsProtos.LifeCycleState var3);

    public int getContainerStateCount(HddsProtos.LifeCycleState var1);

    public boolean containerExist(ContainerID var1);

    public ContainerInfo allocateContainer(ReplicationConfig var1, String var2) throws IOException;

    public void updateContainerState(ContainerID var1, HddsProtos.LifeCycleEvent var2) throws IOException, InvalidStateTransitionException;

    public void transitionDeletingOrDeletedToClosedState(ContainerID var1) throws IOException;

    public Set<ContainerReplica> getContainerReplicas(ContainerID var1) throws ContainerNotFoundException;

    public void updateContainerReplica(ContainerID var1, ContainerReplica var2) throws ContainerNotFoundException;

    public void removeContainerReplica(ContainerID var1, ContainerReplica var2) throws ContainerNotFoundException, ContainerReplicaNotFoundException;

    public void updateDeleteTransactionId(Map<ContainerID, Long> var1) throws IOException;

    default public ContainerInfo getMatchingContainer(long size, String owner, Pipeline pipeline) {
        return this.getMatchingContainer(size, owner, pipeline, Collections.emptySet());
    }

    public ContainerInfo getMatchingContainer(long var1, String var3, Pipeline var4, Set<ContainerID> var5);

    public void notifyContainerReportProcessing(boolean var1, boolean var2);

    public void deleteContainer(ContainerID var1) throws IOException;

    public ContainerStateManager getContainerStateManager();
}

