/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.security.symmetric;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.IOException;
import java.time.Duration;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.protocol.SecretKeyProtocol;
import org.apache.hadoop.hdds.security.exception.SCMSecurityException;
import org.apache.hadoop.hdds.security.symmetric.ManagedSecretKey;
import org.apache.hadoop.hdds.security.symmetric.SecretKeyConfig;
import org.apache.hadoop.hdds.security.symmetric.SecretKeyVerifierClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSecretKeyVerifierClient
implements SecretKeyVerifierClient {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultSecretKeyVerifierClient.class);
    private final LoadingCache<UUID, Optional<ManagedSecretKey>> cache;

    DefaultSecretKeyVerifierClient(final SecretKeyProtocol secretKeyProtocol, ConfigurationSource conf) {
        Duration expiryDuration = SecretKeyConfig.parseExpiryDuration(conf);
        Duration rotateDuration = SecretKeyConfig.parseRotateDuration(conf);
        long expectedValidKeys = expiryDuration.toMillis() / rotateDuration.toMillis() + 1L;
        int secretKeyCacheMultiplier = 2;
        long cacheSize = expectedValidKeys * 2L;
        Duration cacheExpiry = expiryDuration.multipliedBy(2L);
        CacheLoader<UUID, Optional<ManagedSecretKey>> loader = new CacheLoader<UUID, Optional<ManagedSecretKey>>(){

            public Optional<ManagedSecretKey> load(UUID id) throws Exception {
                ManagedSecretKey secretKey = secretKeyProtocol.getSecretKey(id);
                LOG.info("Secret key fetched from SCM: {}", (Object)secretKey);
                return Optional.ofNullable(secretKey);
            }
        };
        LOG.info("Initializing secret key cache with size {}, TTL {}", (Object)cacheSize, (Object)expiryDuration);
        this.cache = CacheBuilder.newBuilder().maximumSize(cacheSize).expireAfterWrite(cacheExpiry.toMillis(), TimeUnit.MILLISECONDS).recordStats().build((CacheLoader)loader);
    }

    @Override
    public ManagedSecretKey getSecretKey(UUID id) throws SCMSecurityException {
        try {
            return ((Optional)this.cache.get((Object)id)).orElse(null);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof IOException) {
                IOException cause = (IOException)e.getCause();
                if (cause instanceof SCMSecurityException) {
                    throw (SCMSecurityException)cause;
                }
                throw new SCMSecurityException("Error fetching secret key " + id + " from SCM", (Throwable)cause);
            }
            throw new IllegalStateException("Unexpected exception fetching secret key " + id + " from SCM", e.getCause());
        }
    }
}

