/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.proxy;

import com.google.common.base.Preconditions;
import java.net.InetSocketAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SCMProxyInfo {
    private static final Logger LOG = LoggerFactory.getLogger(SCMProxyInfo.class);
    private final String serviceId;
    private final String nodeId;
    private final String rpcAddrStr;
    private final InetSocketAddress rpcAddr;

    public SCMProxyInfo(String serviceID, String nodeID, InetSocketAddress rpcAddress) {
        Preconditions.checkNotNull((Object)rpcAddress);
        this.serviceId = serviceID;
        this.nodeId = nodeID;
        this.rpcAddrStr = rpcAddress.toString();
        this.rpcAddr = rpcAddress;
        if (this.rpcAddr.isUnresolved()) {
            LOG.warn("SCM address {} for serviceID {} remains unresolved for node ID {} Check your ozone-site.xml file to ensure scm addresses are configured properly.", new Object[]{rpcAddress, this.serviceId, this.nodeId});
        }
    }

    public String toString() {
        return "nodeId=" + this.nodeId + ",nodeAddress=" + this.rpcAddrStr;
    }

    public InetSocketAddress getAddress() {
        return this.rpcAddr;
    }

    public String getServiceId() {
        return this.serviceId;
    }

    public String getNodeId() {
        return this.nodeId;
    }
}

