/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.utils.db;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.hdds.utils.HddsServerUtil;
import org.apache.hadoop.hdds.utils.db.DumpFileWriter;
import org.apache.hadoop.hdds.utils.db.managed.ManagedEnvOptions;
import org.apache.hadoop.hdds.utils.db.managed.ManagedOptions;
import org.apache.hadoop.hdds.utils.db.managed.ManagedSstFileWriter;
import org.rocksdb.EnvOptions;
import org.rocksdb.Options;
import org.rocksdb.RocksDBException;

public class RDBSstFileWriter
implements DumpFileWriter,
Closeable {
    private ManagedSstFileWriter sstFileWriter;
    private File sstFile;
    private AtomicLong keyCounter;
    private ManagedOptions emptyOption = new ManagedOptions();
    private final ManagedEnvOptions emptyEnvOptions = new ManagedEnvOptions();

    public RDBSstFileWriter() {
        this.sstFileWriter = new ManagedSstFileWriter((EnvOptions)this.emptyEnvOptions, (Options)this.emptyOption);
        this.keyCounter = new AtomicLong(0L);
    }

    @Override
    public void open(File externalFile) throws IOException {
        this.sstFile = externalFile;
        try {
            this.sstFileWriter.open(this.sstFile.getAbsolutePath());
        }
        catch (RocksDBException e) {
            this.closeOnFailure();
            throw HddsServerUtil.toIOException("Failed to open external file for dump " + this.sstFile.getAbsolutePath(), e);
        }
    }

    @Override
    public void put(byte[] key, byte[] value) throws IOException {
        try {
            this.sstFileWriter.put(key, value);
            this.keyCounter.incrementAndGet();
        }
        catch (RocksDBException e) {
            this.closeOnFailure();
            throw HddsServerUtil.toIOException("Failed to put kv into dump file " + this.sstFile.getAbsolutePath(), e);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.sstFileWriter != null) {
            try {
                if (this.keyCounter.get() > 0L) {
                    this.sstFileWriter.finish();
                }
            }
            catch (RocksDBException e) {
                throw HddsServerUtil.toIOException("Failed to finish dumping into file " + this.sstFile.getAbsolutePath(), e);
            }
            finally {
                this.closeResources();
            }
            this.keyCounter.set(0L);
        }
    }

    private void closeResources() {
        this.sstFileWriter.close();
        this.sstFileWriter = null;
        this.emptyOption.close();
        this.emptyEnvOptions.close();
    }

    private void closeOnFailure() {
        if (this.sstFileWriter != null) {
            this.closeResources();
        }
    }
}

