/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.utils.db;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import org.apache.hadoop.hdds.utils.db.DumpFileLoader;
import org.apache.hadoop.hdds.utils.db.RocksDatabase;
import org.apache.hadoop.hdds.utils.db.managed.ManagedIngestExternalFileOptions;

public class RDBSstFileLoader
implements DumpFileLoader,
Closeable {
    private final RocksDatabase db;
    private final RocksDatabase.ColumnFamily family;

    public RDBSstFileLoader(RocksDatabase db, RocksDatabase.ColumnFamily cf) {
        this.db = db;
        this.family = cf;
    }

    @Override
    public void load(File externalFile) throws IOException {
        if (externalFile.length() == 0L) {
            return;
        }
        try (ManagedIngestExternalFileOptions ingestOptions = new ManagedIngestExternalFileOptions();){
            ingestOptions.setIngestBehind(false);
            this.db.ingestExternalFile(this.family, Collections.singletonList(externalFile.getAbsolutePath()), ingestOptions);
        }
    }

    @Override
    public void close() {
    }
}

