/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.utils.db;

import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.time.Instant;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hdds.utils.db.RDBCheckpointUtils;
import org.apache.hadoop.hdds.utils.db.RocksDBCheckpoint;
import org.apache.hadoop.hdds.utils.db.RocksDatabase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RDBCheckpointManager
implements Closeable {
    private final RocksDatabase db;
    private final RocksDatabase.RocksCheckpoint checkpoint;
    public static final String RDB_CHECKPOINT_DIR_PREFIX = "checkpoint_";
    private static final Logger LOG = LoggerFactory.getLogger(RDBCheckpointManager.class);
    private final String checkpointNamePrefix;

    public RDBCheckpointManager(RocksDatabase db, String checkpointPrefix) {
        this.db = db;
        this.checkpointNamePrefix = checkpointPrefix;
        this.checkpoint = db.createCheckpoint();
    }

    public RocksDBCheckpoint createCheckpoint(String parentDir, String name) {
        try {
            long currentTime = System.currentTimeMillis();
            String checkpointDir = "";
            if (StringUtils.isNotEmpty((CharSequence)this.checkpointNamePrefix)) {
                checkpointDir = checkpointDir + this.checkpointNamePrefix;
            }
            if (name == null) {
                name = "_checkpoint_" + currentTime;
            }
            checkpointDir = checkpointDir + name;
            Path checkpointPath = Paths.get(parentDir, checkpointDir);
            Instant start = Instant.now();
            this.db.flushWal(true);
            this.db.flush();
            this.checkpoint.createCheckpoint(checkpointPath);
            long latest = this.checkpoint.getLatestSequenceNumber();
            Instant end = Instant.now();
            long duration = Duration.between(start, end).toMillis();
            LOG.info("Created checkpoint in rocksDB at {} in {} milliseconds", (Object)checkpointPath, (Object)duration);
            RDBCheckpointUtils.waitForCheckpointDirectoryExist(checkpointPath.toFile());
            return new RocksDBCheckpoint(checkpointPath, currentTime, latest, duration);
        }
        catch (IOException e) {
            LOG.error("Unable to create RocksDB Snapshot.", (Throwable)e);
            return null;
        }
    }

    public RocksDBCheckpoint createCheckpoint(String parentDir) {
        return this.createCheckpoint(parentDir, null);
    }

    @Override
    public void close() throws IOException {
        this.checkpoint.close();
    }
}

