/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.security.x509.certificate;

import com.google.protobuf.MessageLite;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.io.Serializable;
import java.security.cert.X509Certificate;
import java.util.Comparator;
import java.util.Objects;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.security.exception.SCMSecurityException;
import org.apache.hadoop.hdds.security.x509.certificate.utils.CertificateCodec;
import org.apache.hadoop.hdds.utils.db.Codec;
import org.apache.hadoop.hdds.utils.db.DelegatedCodec;
import org.apache.hadoop.hdds.utils.db.Proto2Codec;

public final class CertInfo
implements Comparable<CertInfo>,
Serializable {
    private static final Codec<CertInfo> CODEC = new DelegatedCodec(Proto2Codec.get((MessageLite)HddsProtos.CertInfoProto.getDefaultInstance()), CertInfo::fromProtobuf, CertInfo::getProtobuf, CertInfo.class);
    static final Comparator<CertInfo> COMPARATOR = Comparator.comparingLong(CertInfo::getTimestamp);
    private final X509Certificate x509Certificate;
    private final long timestamp;

    public static Codec<CertInfo> getCodec() {
        return CODEC;
    }

    private CertInfo(X509Certificate x509Certificate, long timestamp) {
        this.x509Certificate = x509Certificate;
        this.timestamp = timestamp;
    }

    public static CertInfo fromProtobuf(HddsProtos.CertInfoProto info) throws IOException {
        return new Builder().setX509Certificate(info.getX509Certificate()).setTimestamp(info.getTimestamp()).build();
    }

    public HddsProtos.CertInfoProto getProtobuf() throws SCMSecurityException {
        return HddsProtos.CertInfoProto.newBuilder().setX509Certificate(this.getX509CertificatePEMEncodedString()).setTimestamp(this.getTimestamp()).build();
    }

    public X509Certificate getX509Certificate() {
        return this.x509Certificate;
    }

    public String getX509CertificatePEMEncodedString() throws SCMSecurityException {
        return CertificateCodec.getPEMEncodedString((X509Certificate)this.getX509Certificate());
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public int compareTo(@Nonnull CertInfo o) {
        return COMPARATOR.compare(this, o);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CertInfo that = (CertInfo)o;
        return this.getX509Certificate().equals(that.getX509Certificate()) && this.getTimestamp() == that.getTimestamp();
    }

    public int hashCode() {
        return Objects.hash(this.getX509Certificate(), this.getTimestamp());
    }

    public String toString() {
        return "CertInfo{x509Certificate=" + this.x509Certificate.toString() + ", timestamp=" + this.timestamp + '}';
    }

    public static class Builder {
        private X509Certificate x509Certificate;
        private long timestamp;

        public Builder setX509Certificate(X509Certificate x509Certificate) {
            this.x509Certificate = x509Certificate;
            return this;
        }

        public Builder setX509Certificate(String x509Certificate) throws IOException {
            return this.setX509Certificate(CertificateCodec.getX509Certificate((String)x509Certificate, CertificateCodec::toIOException));
        }

        public Builder setTimestamp(long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public CertInfo build() {
            return new CertInfo(this.x509Certificate, this.timestamp);
        }
    }
}

