/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.fs;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.time.Duration;
import org.apache.hadoop.hdds.annotation.InterfaceAudience;
import org.apache.hadoop.hdds.annotation.InterfaceStability;
import org.apache.hadoop.hdds.fs.SpaceUsagePersistence;
import org.apache.hadoop.hdds.fs.SpaceUsageSource;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class SpaceUsageCheckParams {
    private final SpaceUsageSource source;
    private final Duration refresh;
    private final SpaceUsagePersistence persistence;
    private final String path;
    private final File dir;

    public SpaceUsageCheckParams(File dir, SpaceUsageSource source, Duration refresh, SpaceUsagePersistence persistence) {
        Preconditions.checkArgument((dir != null ? 1 : 0) != 0, (Object)"dir == null");
        Preconditions.checkArgument((source != null ? 1 : 0) != 0, (Object)"source == null");
        Preconditions.checkArgument((refresh != null ? 1 : 0) != 0, (Object)"refresh == null");
        Preconditions.checkArgument((persistence != null ? 1 : 0) != 0, (Object)"persistence == null");
        Preconditions.checkArgument((!refresh.isNegative() ? 1 : 0) != 0, (Object)"refresh is negative");
        this.dir = dir;
        this.source = source;
        this.refresh = refresh;
        this.persistence = persistence;
        try {
            this.path = dir.getCanonicalPath();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public File getDir() {
        return this.dir;
    }

    public String getPath() {
        return this.path;
    }

    public SpaceUsageSource getSource() {
        return this.source;
    }

    public Duration getRefresh() {
        return this.refresh;
    }

    public SpaceUsagePersistence getPersistence() {
        return this.persistence;
    }
}

