/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozone.erasurecode.rawcoder;

import java.nio.ByteBuffer;
import java.util.Arrays;
import org.apache.hadoop.hdds.annotation.InterfaceAudience;
import org.apache.hadoop.hdds.client.ECReplicationConfig;
import org.apache.ozone.erasurecode.rawcoder.ByteArrayDecodingState;
import org.apache.ozone.erasurecode.rawcoder.ByteBufferDecodingState;
import org.apache.ozone.erasurecode.rawcoder.CoderUtil;
import org.apache.ozone.erasurecode.rawcoder.RawErasureDecoder;
import org.apache.ozone.erasurecode.rawcoder.util.DumpUtil;
import org.apache.ozone.erasurecode.rawcoder.util.GF256;
import org.apache.ozone.erasurecode.rawcoder.util.RSUtil;

@InterfaceAudience.Private
public class RSRawDecoder
extends RawErasureDecoder {
    private byte[] encodeMatrix;
    private byte[] decodeMatrix;
    private byte[] invertMatrix;
    private byte[] gfTables;
    private int[] cachedErasedIndexes;
    private int[] validIndexes;
    private int numErasedDataUnits;
    private boolean[] erasureFlags;

    public RSRawDecoder(ECReplicationConfig ecReplicationConfig) {
        super(ecReplicationConfig);
        int numAllUnits = this.getNumAllUnits();
        if (this.getNumAllUnits() >= RSUtil.GF.getFieldSize()) {
            throw new IllegalArgumentException("Invalid getNumDataUnits() and numParityUnits");
        }
        this.encodeMatrix = new byte[numAllUnits * this.getNumDataUnits()];
        RSUtil.genCauchyMatrix(this.encodeMatrix, numAllUnits, this.getNumDataUnits());
        if (this.allowVerboseDump()) {
            DumpUtil.dumpMatrix(this.encodeMatrix, this.getNumDataUnits(), numAllUnits);
        }
    }

    @Override
    protected void doDecode(ByteBufferDecodingState decodingState) {
        CoderUtil.resetOutputBuffers(decodingState.outputs, decodingState.decodeLength);
        this.prepareDecoding(decodingState.inputs, decodingState.erasedIndexes);
        ByteBuffer[] realInputs = new ByteBuffer[this.getNumDataUnits()];
        for (int i = 0; i < this.getNumDataUnits(); ++i) {
            realInputs[i] = decodingState.inputs[this.validIndexes[i]];
        }
        RSUtil.encodeData(this.gfTables, realInputs, decodingState.outputs);
    }

    @Override
    protected void doDecode(ByteArrayDecodingState decodingState) {
        int dataLen = decodingState.decodeLength;
        CoderUtil.resetOutputBuffers(decodingState.outputs, decodingState.outputOffsets, dataLen);
        this.prepareDecoding((T[])decodingState.inputs, decodingState.erasedIndexes);
        byte[][] realInputs = new byte[this.getNumDataUnits()][];
        int[] realInputOffsets = new int[this.getNumDataUnits()];
        for (int i = 0; i < this.getNumDataUnits(); ++i) {
            realInputs[i] = decodingState.inputs[this.validIndexes[i]];
            realInputOffsets[i] = decodingState.inputOffsets[this.validIndexes[i]];
        }
        RSUtil.encodeData(this.gfTables, dataLen, realInputs, realInputOffsets, decodingState.outputs, decodingState.outputOffsets);
    }

    private <T> void prepareDecoding(T[] inputs, int[] erasedIndexes) {
        int[] tmpValidIndexes = CoderUtil.getValidIndexes(inputs);
        if (Arrays.equals(this.cachedErasedIndexes, erasedIndexes) && Arrays.equals(this.validIndexes, tmpValidIndexes)) {
            return;
        }
        this.cachedErasedIndexes = Arrays.copyOf(erasedIndexes, erasedIndexes.length);
        this.validIndexes = Arrays.copyOf(tmpValidIndexes, tmpValidIndexes.length);
        this.processErasures(erasedIndexes);
    }

    private void processErasures(int[] erasedIndexes) {
        this.decodeMatrix = new byte[this.getNumAllUnits() * this.getNumDataUnits()];
        this.invertMatrix = new byte[this.getNumAllUnits() * this.getNumDataUnits()];
        this.gfTables = new byte[this.getNumAllUnits() * this.getNumDataUnits() * 32];
        this.erasureFlags = new boolean[this.getNumAllUnits()];
        this.numErasedDataUnits = 0;
        for (int index : erasedIndexes) {
            this.erasureFlags[index] = true;
            if (index >= this.getNumDataUnits()) continue;
            ++this.numErasedDataUnits;
        }
        this.generateDecodeMatrix(erasedIndexes);
        RSUtil.initTables(this.getNumDataUnits(), erasedIndexes.length, this.decodeMatrix, 0, this.gfTables);
        if (this.allowVerboseDump()) {
            System.out.println(DumpUtil.bytesToHex(this.gfTables, -1));
        }
    }

    private void generateDecodeMatrix(int[] erasedIndexes) {
        int j;
        int i;
        byte[] tmpMatrix = new byte[this.getNumAllUnits() * this.getNumDataUnits()];
        for (i = 0; i < this.getNumDataUnits(); ++i) {
            int r = this.validIndexes[i];
            for (j = 0; j < this.getNumDataUnits(); ++j) {
                tmpMatrix[this.getNumDataUnits() * i + j] = this.encodeMatrix[this.getNumDataUnits() * r + j];
            }
        }
        GF256.gfInvertMatrix(tmpMatrix, this.invertMatrix, this.getNumDataUnits());
        for (i = 0; i < this.numErasedDataUnits; ++i) {
            for (j = 0; j < this.getNumDataUnits(); ++j) {
                this.decodeMatrix[this.getNumDataUnits() * i + j] = this.invertMatrix[this.getNumDataUnits() * erasedIndexes[i] + j];
            }
        }
        for (int p = this.numErasedDataUnits; p < erasedIndexes.length; ++p) {
            for (i = 0; i < this.getNumDataUnits(); ++i) {
                byte s = 0;
                for (j = 0; j < this.getNumDataUnits(); ++j) {
                    s = (byte)(s ^ GF256.gfMul(this.invertMatrix[j * this.getNumDataUnits() + i], this.encodeMatrix[this.getNumDataUnits() * erasedIndexes[p] + j]));
                }
                this.decodeMatrix[this.getNumDataUnits() * p + i] = s;
            }
        }
    }
}

