/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozone.erasurecode.rawcoder;

import org.apache.hadoop.hdds.client.ECReplicationConfig;
import org.apache.ozone.erasurecode.rawcoder.ByteArrayEncodingState;
import org.apache.ozone.erasurecode.rawcoder.ByteBufferEncodingState;
import org.apache.ozone.erasurecode.rawcoder.CoderUtil;
import org.apache.ozone.erasurecode.rawcoder.RawErasureEncoder;
import org.apache.ozone.erasurecode.rawcoder.util.DumpUtil;
import org.apache.ozone.erasurecode.rawcoder.util.RSUtil;

public class RSRawEncoder
extends RawErasureEncoder {
    private byte[] encodeMatrix;
    private byte[] gfTables;

    public RSRawEncoder(ECReplicationConfig ecReplicationConfig) {
        super(ecReplicationConfig);
        if (this.getNumAllUnits() >= RSUtil.GF.getFieldSize()) {
            throw new IllegalArgumentException("Invalid numDataUnits and numParityUnits");
        }
        this.encodeMatrix = new byte[this.getNumAllUnits() * this.getNumDataUnits()];
        RSUtil.genCauchyMatrix(this.encodeMatrix, this.getNumAllUnits(), this.getNumDataUnits());
        if (this.allowVerboseDump()) {
            DumpUtil.dumpMatrix(this.encodeMatrix, this.getNumDataUnits(), this.getNumAllUnits());
        }
        this.gfTables = new byte[this.getNumAllUnits() * this.getNumDataUnits() * 32];
        RSUtil.initTables(this.getNumDataUnits(), this.getNumParityUnits(), this.encodeMatrix, this.getNumDataUnits() * this.getNumDataUnits(), this.gfTables);
        if (this.allowVerboseDump()) {
            System.out.println(DumpUtil.bytesToHex(this.gfTables, -1));
        }
    }

    @Override
    protected void doEncode(ByteBufferEncodingState encodingState) {
        CoderUtil.resetOutputBuffers(encodingState.outputs, encodingState.encodeLength);
        RSUtil.encodeData(this.gfTables, encodingState.inputs, encodingState.outputs);
    }

    @Override
    protected void doEncode(ByteArrayEncodingState encodingState) {
        CoderUtil.resetOutputBuffers(encodingState.outputs, encodingState.outputOffsets, encodingState.encodeLength);
        RSUtil.encodeData(this.gfTables, encodingState.encodeLength, encodingState.inputs, encodingState.inputOffsets, encodingState.outputs, encodingState.outputOffsets);
    }
}

