/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.common.utils;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.GatheringByteChannel;
import java.util.ArrayList;
import java.util.List;
import org.apache.ratis.thirdparty.com.google.protobuf.ByteString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BufferUtils {
    private static final Logger LOG = LoggerFactory.getLogger(BufferUtils.class);
    private static final ByteBuffer[] EMPTY_BYTE_BUFFER_ARRAY = new ByteBuffer[0];

    private BufferUtils() {
    }

    public static ByteBuffer[] assignByteBuffers(long totalLen, int bufferCapacity) {
        Preconditions.checkArgument((totalLen > 0L ? 1 : 0) != 0, (Object)"Buffer Length should be a positive integer.");
        Preconditions.checkArgument((bufferCapacity > 0 ? 1 : 0) != 0, (Object)"Buffer Capacity should be a positive integer.");
        int numBuffers = BufferUtils.getNumberOfBins(totalLen, bufferCapacity);
        ByteBuffer[] dataBuffers = new ByteBuffer[numBuffers];
        long allocatedLen = 0L;
        for (int i = 0; i < numBuffers - 1; ++i) {
            dataBuffers[i] = ByteBuffer.allocate(bufferCapacity);
            allocatedLen += (long)bufferCapacity;
        }
        dataBuffers[numBuffers - 1] = ByteBuffer.allocate(Math.toIntExact(totalLen - allocatedLen));
        return dataBuffers;
    }

    public static List<ByteBuffer> getReadOnlyByteBuffers(List<ByteString> byteStrings) {
        ArrayList<ByteBuffer> buffers = new ArrayList<ByteBuffer>();
        for (ByteString byteString : byteStrings) {
            buffers.add(byteString.asReadOnlyByteBuffer());
        }
        return buffers;
    }

    public static ByteBuffer[] getReadOnlyByteBuffers(ByteBuffer[] byteBuffers) {
        if (byteBuffers == null) {
            return null;
        }
        ByteBuffer[] readOnlyBuffers = new ByteBuffer[byteBuffers.length];
        for (int i = 0; i < byteBuffers.length; ++i) {
            readOnlyBuffers[i] = byteBuffers[i] == null ? null : byteBuffers[i].asReadOnlyBuffer();
        }
        return readOnlyBuffers;
    }

    public static ByteBuffer[] getReadOnlyByteBuffersArray(List<ByteString> byteStrings) {
        return BufferUtils.getReadOnlyByteBuffers(byteStrings).toArray(new ByteBuffer[0]);
    }

    public static ByteString concatByteStrings(List<ByteString> byteStrings) {
        ByteString result = ByteString.EMPTY;
        for (ByteString byteString : byteStrings) {
            result = result.concat(byteString);
        }
        return result;
    }

    public static long getBuffersLen(List<ByteString> buffers) {
        long length = 0L;
        for (ByteString buffer : buffers) {
            length += (long)buffer.size();
        }
        return length;
    }

    public static int getNumberOfBins(long numElements, int maxElementsPerBin) {
        Preconditions.checkArgument((numElements >= 0L ? 1 : 0) != 0);
        Preconditions.checkArgument((maxElementsPerBin > 0 ? 1 : 0) != 0);
        long n = 1L + (numElements - 1L) / (long)maxElementsPerBin;
        if (n > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Integer overflow: n = " + n + " > Integer.MAX_VALUE = " + Integer.MAX_VALUE + ", numElements = " + numElements + ", maxElementsPerBin = " + maxElementsPerBin);
        }
        return Math.toIntExact(n);
    }

    public static long writeFully(GatheringByteChannel ch, ByteBuffer bb) throws IOException {
        long written = 0L;
        while (bb.remaining() > 0) {
            int n = ch.write(bb);
            if (n < 0) {
                throw new IllegalStateException("GatheringByteChannel.write returns " + n + " < 0 for " + ch);
            }
            written += (long)n;
        }
        return written;
    }

    public static long writeFully(GatheringByteChannel ch, List<ByteBuffer> buffers) throws IOException {
        return BufferUtils.writeFully(ch, buffers.toArray(EMPTY_BYTE_BUFFER_ARRAY));
    }

    public static long writeFully(GatheringByteChannel ch, ByteBuffer[] buffers) throws IOException {
        if (LOG.isDebugEnabled()) {
            for (int i = 0; i < buffers.length; ++i) {
                LOG.debug("buffer[{}]: remaining={}", (Object)i, (Object)buffers[i].remaining());
            }
        }
        long written = 0L;
        for (int i = 0; i < buffers.length; ++i) {
            while (buffers[i].remaining() > 0) {
                long n = ch.write(buffers, i, buffers.length - i);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("buffer[{}]: remaining={}, written={}", new Object[]{i, buffers[i].remaining(), n});
                }
                if (n < 0L) {
                    throw new IllegalStateException("GatheringByteChannel.write returns " + n + " < 0 for " + ch);
                }
                written += n;
            }
        }
        return written;
    }
}

