/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.utils.db;

import jakarta.annotation.Nonnull;
import java.nio.ByteBuffer;
import org.apache.hadoop.hdds.utils.db.Codec;
import org.apache.hadoop.hdds.utils.db.CodecBuffer;

public final class IntegerCodec
implements Codec<Integer> {
    private static final IntegerCodec INSTANCE = new IntegerCodec();

    public static IntegerCodec get() {
        return INSTANCE;
    }

    private IntegerCodec() {
    }

    @Override
    public Class<Integer> getTypeClass() {
        return Integer.class;
    }

    @Override
    public boolean supportCodecBuffer() {
        return true;
    }

    @Override
    public CodecBuffer toCodecBuffer(@Nonnull Integer object, CodecBuffer.Allocator allocator) {
        return ((CodecBuffer)allocator.apply(4)).putInt(object);
    }

    @Override
    public Integer fromCodecBuffer(@Nonnull CodecBuffer buffer) {
        return buffer.asReadOnlyByteBuffer().getInt();
    }

    @Override
    public byte[] toPersistedFormat(Integer object) {
        return ByteBuffer.wrap(new byte[4]).putInt(object).array();
    }

    @Override
    public Integer fromPersistedFormat(byte[] rawData) {
        return ByteBuffer.wrap(rawData).getInt();
    }

    @Override
    public Integer copyObject(Integer object) {
        return object;
    }
}

