/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.upgrade;

import java.util.EnumMap;
import java.util.Optional;
import org.apache.hadoop.hdds.upgrade.HDDSUpgradeAction;
import org.apache.hadoop.ozone.upgrade.LayoutFeature;

public enum HDDSLayoutFeature implements LayoutFeature
{
    INITIAL_VERSION(0, "Initial Layout Version"),
    DATANODE_SCHEMA_V2(1, "Datanode RocksDB Schema Version 2 (with column families)"),
    SCM_HA(2, "Storage Container Manager HA"),
    ERASURE_CODED_STORAGE_SUPPORT(3, "Ozone version with built in support for Erasure Coded block data storage."),
    DATANODE_SCHEMA_V3(4, "Datanode RocksDB Schema Version 3 (one rocksdb per disk)"),
    RATIS_DATASTREAM_PORT_IN_DATANODEDETAILS(5, "Adding the RATIS_DATASTREAM port to the DatanodeDetails."),
    WEBUI_PORTS_IN_DATANODEDETAILS(6, "Adding HTTP and HTTPS ports to DatanodeDetails."),
    HADOOP_PRC_PORTS_IN_DATANODEDETAILS(7, "Adding Hadoop RPC ports to DatanodeDetails."),
    HBASE_SUPPORT(8, "Datanode RocksDB Schema Version 3 has an extra table for the last chunk of blocks to support HBase.)"),
    WITNESSED_CONTAINER_DB_PROTO_VALUE(9, "ContainerID table schema to use value type as proto");

    private int layoutVersion;
    private String description;
    private EnumMap<LayoutFeature.UpgradeActionType, HDDSUpgradeAction> scmActions = new EnumMap(LayoutFeature.UpgradeActionType.class);
    private EnumMap<LayoutFeature.UpgradeActionType, HDDSUpgradeAction> datanodeActions = new EnumMap(LayoutFeature.UpgradeActionType.class);

    private HDDSLayoutFeature(int layoutVersion, String description) {
        this.layoutVersion = layoutVersion;
        this.description = description;
    }

    public void addScmAction(LayoutFeature.UpgradeActionType type, HDDSUpgradeAction action) {
        this.scmActions.put(type, action);
    }

    public void addDatanodeAction(LayoutFeature.UpgradeActionType type, HDDSUpgradeAction action) {
        this.datanodeActions.put(type, action);
    }

    @Override
    public int layoutVersion() {
        return this.layoutVersion;
    }

    @Override
    public String description() {
        return this.description;
    }

    public Optional<HDDSUpgradeAction> scmAction(LayoutFeature.UpgradeActionType type) {
        return Optional.ofNullable(this.scmActions.get((Object)type));
    }

    public Optional<HDDSUpgradeAction> datanodeAction(LayoutFeature.UpgradeActionType type) {
        return Optional.ofNullable(this.datanodeActions.get((Object)type));
    }
}

