/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.container;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.UUID;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.server.JsonUtils;

public final class ContainerReplicaInfo {
    private long containerID;
    private String state;
    private DatanodeDetails datanodeDetails;
    private UUID placeOfBirth;
    private long sequenceId;
    private long keyCount;
    private long bytesUsed;
    private int replicaIndex = -1;
    @JsonSerialize(using=JsonUtils.ChecksumSerializer.class)
    private long dataChecksum;

    public static ContainerReplicaInfo fromProto(HddsProtos.SCMContainerReplicaProto proto) {
        Builder builder = new Builder();
        builder.setContainerID(proto.getContainerID()).setState(proto.getState()).setDatanodeDetails(DatanodeDetails.getFromProtoBuf(proto.getDatanodeDetails())).setPlaceOfBirth(UUID.fromString(proto.getPlaceOfBirth())).setSequenceId(proto.getSequenceID()).setKeyCount(proto.getKeyCount()).setBytesUsed(proto.getBytesUsed()).setReplicaIndex(proto.hasReplicaIndex() ? (int)proto.getReplicaIndex() : -1).setDataChecksum(proto.getDataChecksum());
        return builder.build();
    }

    private ContainerReplicaInfo() {
    }

    public long getContainerID() {
        return this.containerID;
    }

    public String getState() {
        return this.state;
    }

    public DatanodeDetails getDatanodeDetails() {
        return this.datanodeDetails;
    }

    public UUID getPlaceOfBirth() {
        return this.placeOfBirth;
    }

    public long getSequenceId() {
        return this.sequenceId;
    }

    public long getKeyCount() {
        return this.keyCount;
    }

    public long getBytesUsed() {
        return this.bytesUsed;
    }

    public int getReplicaIndex() {
        return this.replicaIndex;
    }

    public long getDataChecksum() {
        return this.dataChecksum;
    }

    public static class Builder {
        private final ContainerReplicaInfo subject = new ContainerReplicaInfo();

        public Builder setContainerID(long containerID) {
            this.subject.containerID = containerID;
            return this;
        }

        public Builder setState(String state) {
            this.subject.state = state;
            return this;
        }

        public Builder setDatanodeDetails(DatanodeDetails datanodeDetails) {
            this.subject.datanodeDetails = datanodeDetails;
            return this;
        }

        public Builder setPlaceOfBirth(UUID placeOfBirth) {
            this.subject.placeOfBirth = placeOfBirth;
            return this;
        }

        public Builder setSequenceId(long sequenceId) {
            this.subject.sequenceId = sequenceId;
            return this;
        }

        public Builder setKeyCount(long keyCount) {
            this.subject.keyCount = keyCount;
            return this;
        }

        public Builder setBytesUsed(long bytesUsed) {
            this.subject.bytesUsed = bytesUsed;
            return this;
        }

        public Builder setReplicaIndex(int replicaIndex) {
            this.subject.replicaIndex = replicaIndex;
            return this;
        }

        public Builder setDataChecksum(long dataChecksum) {
            this.subject.dataChecksum = dataChecksum;
            return this;
        }

        public ContainerReplicaInfo build() {
            return this.subject;
        }
    }
}

