/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.common;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.zip.CRC32;
import java.util.zip.Checksum;
import org.apache.hadoop.hdds.JavaUtils;
import org.apache.hadoop.ozone.common.ChecksumByteBuffer;
import org.apache.hadoop.ozone.common.ChecksumByteBufferImpl;
import org.apache.hadoop.util.PureJavaCrc32C;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ChecksumByteBufferFactory {
    private static final Logger LOG = LoggerFactory.getLogger(ChecksumByteBufferImpl.class);
    private static volatile boolean useJava9Crc32C = JavaUtils.isJavaVersionAtLeast(9);

    public static ChecksumByteBuffer crc32Impl() {
        return new ChecksumByteBufferImpl(new CRC32());
    }

    public static ChecksumByteBuffer crc32CImpl() {
        if (useJava9Crc32C) {
            try {
                return new ChecksumByteBufferImpl(Java9Crc32CFactory.createChecksum());
            }
            catch (Throwable e) {
                LOG.error("CRC32C creation failed, switching to PureJavaCrc32C", e);
                useJava9Crc32C = false;
            }
        }
        return new ChecksumByteBufferImpl((Checksum)new PureJavaCrc32C());
    }

    private ChecksumByteBufferFactory() {
    }

    public static class Java9Crc32CFactory {
        private static final MethodHandle NEW_CRC32C_MH;

        public static Checksum createChecksum() {
            try {
                return NEW_CRC32C_MH.invoke();
            }
            catch (Throwable t) {
                throw t instanceof RuntimeException ? (RuntimeException)t : new RuntimeException(t);
            }
        }

        static {
            MethodHandle newCRC32C = null;
            try {
                newCRC32C = MethodHandles.publicLookup().findConstructor(Class.forName("java.util.zip.CRC32C"), MethodType.methodType(Void.TYPE));
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException(e);
            }
            NEW_CRC32C_MH = newCRC32C;
        }
    }
}

